/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.attribute.SignatureParser;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class SignatureAttribute
extends AttributeInfo {
    private final String signature;

    public SignatureAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        if (is.readInt() != 2) {
            throw new IllegalArgumentException("Unexpected length of Signature attribute.");
        }
        this.signature = constantPool.getUtf8String(is.readUnsignedShort());
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        SignatureParser parser = new SignatureParser(this.signature, classNames);
        switch (this.getContext()) {
            case CLASS: {
                parser.parseClassSignature();
                break;
            }
            case METHOD: {
                parser.parseMethodSignature();
                break;
            }
            case FIELD: {
                parser.parseFieldSignature();
                break;
            }
            default: {
                throw new IllegalArgumentException("Signature attribute not supported for context " + (Object)((Object)this.getContext()) + "!");
            }
        }
    }
}

