/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import java.util.HashSet;
import java.util.Set;

public class SignatureParser {
    private final Set<String> dependentClasses;
    private final String signature;
    private int position;

    public SignatureParser(String signature, Set<String> dependentClasses) {
        this.dependentClasses = dependentClasses;
        this.signature = signature;
    }

    public SignatureParser(String signature) {
        this(signature, new HashSet<String>());
    }

    public boolean parseClassSignature() {
        this.parseTypeParameters();
        this.ensure(this.parseSuperclassSignature());
        while (this.parseSuperInterfaceSignature()) {
        }
        return true;
    }

    private boolean parseTypeParameters() {
        if ('<' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.parseTypeParameter();
        while (this.parseTypeParameter()) {
        }
        this.ensure('>' == this.lookAhead());
        ++this.position;
        return true;
    }

    private boolean parseTypeParameter() {
        int lastIndex = this.position;
        this.parseIdentifier();
        if (!this.parseClassBound()) {
            this.position = lastIndex;
            return false;
        }
        while (this.parseInterfaceBound()) {
        }
        return true;
    }

    private boolean parseClassBound() {
        if (':' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.parseReferenceTypeSignature();
        return true;
    }

    private boolean parseInterfaceBound() {
        if (':' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseReferenceTypeSignature());
        return true;
    }

    private boolean parseSuperclassSignature() {
        this.ensure(this.parseClassTypeSignature());
        return true;
    }

    private boolean parseSuperInterfaceSignature() {
        return this.parseClassTypeSignature();
    }

    public boolean parseMethodSignature() {
        this.parseTypeParameters();
        this.ensure('(' == this.lookAhead());
        ++this.position;
        while (this.parseJavaTypeSignature()) {
        }
        this.ensure(')' == this.lookAhead());
        ++this.position;
        this.ensure(this.parseResult());
        while (this.parseThrowsSignature()) {
        }
        return true;
    }

    private boolean parseResult() {
        return this.parseVoidDescriptor() || this.parseJavaTypeSignature();
    }

    private boolean parseVoidDescriptor() {
        if ('V' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        return true;
    }

    private boolean parseThrowsSignature() {
        if ('^' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseClassTypeSignature() || this.parseTypeVariableSignature());
        return true;
    }

    public boolean parseFieldSignature() {
        this.ensure(this.parseReferenceTypeSignature());
        return true;
    }

    public boolean parseJavaTypeSignature() {
        return this.parseBaseType() || this.parseReferenceTypeSignature();
    }

    private boolean parseReferenceTypeSignature() {
        return this.parseClassTypeSignature() || this.parseTypeVariableSignature() || this.parseArrayTypeSignature();
    }

    private boolean parseClassTypeSignature() {
        if ('L' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        int start = this.position;
        this.parsePackageSpecifier();
        this.ensure(this.parseSimpleClassTypeSignature());
        while (this.parseClassTypeSignatureSuffix()) {
        }
        this.ensure(';' == this.lookAhead());
        String classname = this.signature.substring(start, this.position);
        int typeIndex = classname.indexOf(60);
        if (typeIndex == -1) {
            typeIndex = classname.length();
        }
        this.dependentClasses.add(classname.substring(0, typeIndex).replace('/', '.'));
        ++this.position;
        return true;
    }

    private boolean parsePackageSpecifier() {
        int lastIndex = this.position++;
        this.parseIdentifier();
        if ('/' != this.lookAhead()) {
            this.position = lastIndex;
            return false;
        }
        this.parsePackageSpecifier();
        return true;
    }

    private boolean parseSimpleClassTypeSignature() {
        this.ensure(this.parseIdentifier());
        this.parseTypeArguments();
        return true;
    }

    private boolean parseTypeArguments() {
        if ('<' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseTypeArgument());
        while (this.parseTypeArgument()) {
        }
        this.ensure('>' == this.lookAhead());
        ++this.position;
        return true;
    }

    private boolean parseTypeArgument() {
        if ('*' == this.lookAhead()) {
            ++this.position;
            return true;
        }
        this.parseWildcardIndicator();
        return this.parseReferenceTypeSignature();
    }

    private boolean parseWildcardIndicator() {
        if ("+-".indexOf(this.lookAhead()) == -1) {
            return false;
        }
        ++this.position;
        return true;
    }

    private boolean parseClassTypeSignatureSuffix() {
        if ('.' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseSimpleClassTypeSignature());
        return true;
    }

    private boolean parseTypeVariableSignature() {
        if ('T' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseIdentifier());
        this.ensure(';' == this.lookAhead());
        ++this.position;
        return true;
    }

    private boolean parseArrayTypeSignature() {
        if ('[' != this.lookAhead()) {
            return false;
        }
        ++this.position;
        this.ensure(this.parseJavaTypeSignature());
        return true;
    }

    private boolean parseIdentifier() {
        if (!Character.isJavaIdentifierStart(this.lookAhead())) {
            return false;
        }
        ++this.position;
        while (Character.isJavaIdentifierPart(this.lookAhead())) {
            ++this.position;
        }
        return true;
    }

    private boolean parseBaseType() {
        if ("BCDFIJSZ".indexOf(this.lookAhead()) == -1) {
            return false;
        }
        ++this.position;
        return true;
    }

    private char lookAhead() {
        if (this.position >= this.signature.length()) {
            return '\u0000';
        }
        return this.signature.charAt(this.position);
    }

    private void ensure(boolean parsed) {
        if (!parsed) {
            throw new IllegalArgumentException(this.signature + " is invalid at position " + this.position + ": " + this.signature.substring(this.position));
        }
    }

    public boolean isComplete() {
        return this.position == this.signature.length();
    }

    public Set<String> getDependentClasses() {
        return this.dependentClasses;
    }

    public String getSignature() {
        return this.signature;
    }
}

