/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantNameAndType;
import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.MethodType;
import java.util.BitSet;
import java.util.Set;

class ConstantDynamic
extends ConstantPoolEntry {
    public static final int TAG = 17;
    private final int bootstrapMethodAttrIndex;
    private final int nameAndTypeIndex;
    private MethodType type;

    public ConstantDynamic(int bootstrapMethodAttrIndex, int referenceIndex) {
        this.bootstrapMethodAttrIndex = bootstrapMethodAttrIndex;
        this.nameAndTypeIndex = referenceIndex;
    }

    @Override
    void recordReferences(BitSet references) {
        references.set(this.nameAndTypeIndex);
    }

    @Override
    public String dump() {
        return this.dump("[" + this.bootstrapMethodAttrIndex + "]." + ConstantDynamic.index(this.nameAndTypeIndex), "[bootstrapMethodAttrIndex=" + this.bootstrapMethodAttrIndex + "]." + this.getMethodName() + ": " + this.getMethodType());
    }

    public int getBootstrapMethodAttrIndex() {
        return this.bootstrapMethodAttrIndex;
    }

    public String getMethodName() {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
        return nameAndType.getName();
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
            this.type = new MethodType(nameAndType.getDescriptor());
        }
        return this.type;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.getMethodType().addDependentClassNames(classNames);
    }
}

