/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantClass;
import de.spricom.dessert.classfile.constpool.ConstantNameAndType;
import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.FieldType;
import java.util.BitSet;
import java.util.Set;

class ConstantFieldref
extends ConstantPoolEntry {
    public static final int TAG = 9;
    private final int classIndex;
    private final int nameAndTypeIndex;
    private FieldType type;

    public ConstantFieldref(int classIndex, int nameAndTypeIndex) {
        this.classIndex = classIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    void recordReferences(BitSet references) {
        references.set(this.classIndex);
        references.set(this.nameAndTypeIndex);
    }

    @Override
    public String dump() {
        return this.dump(ConstantFieldref.index(this.classIndex) + "." + ConstantFieldref.index(this.nameAndTypeIndex), this.getClassName() + "." + this.getFieldName() + ": " + this.getFieldType());
    }

    public String getClassName() {
        ConstantClass clazz = (ConstantClass)this.getConstantPoolEntry(this.classIndex);
        return clazz.getName();
    }

    public String getFieldName() {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
        return nameAndType.getName();
    }

    public FieldType getFieldType() {
        if (this.type == null) {
            ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
            this.type = new FieldType(nameAndType.getDescriptor());
        }
        return this.type;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.getFieldType().addDependentClassNames(classNames);
    }
}

