/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantClass;
import de.spricom.dessert.classfile.constpool.ConstantNameAndType;
import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.MethodType;
import java.util.BitSet;
import java.util.Set;

class ConstantMethodref
extends ConstantPoolEntry {
    public static final int TAG = 10;
    private final int classIndex;
    private final int nameAndTypeIndex;
    private MethodType type;

    public ConstantMethodref(int classIndex, int nameAndTypeIndex) {
        this.classIndex = classIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    @Override
    void recordReferences(BitSet references) {
        references.set(this.classIndex);
        references.set(this.nameAndTypeIndex);
    }

    @Override
    public String dump() {
        return this.dump(ConstantMethodref.index(this.classIndex) + "." + ConstantMethodref.index(this.nameAndTypeIndex), this.getClassName() + "." + this.getMethodName() + ": " + this.getMethodType());
    }

    public String getClassName() {
        ConstantClass clazz = (ConstantClass)this.getConstantPoolEntry(this.classIndex);
        return clazz.getName();
    }

    public String getMethodName() {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
        return nameAndType.getName();
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(this.nameAndTypeIndex);
            this.type = new MethodType(nameAndType.getDescriptor());
        }
        return this.type;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.getMethodType().addDependentClassNames(classNames);
    }
}

