/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.matching;

import de.spricom.dessert.matching.AbstractShortNameMatcher;
import de.spricom.dessert.matching.MissShortNameMatcher;
import de.spricom.dessert.matching.ShortNameMatcher;
import java.util.regex.Pattern;

class RegexShortNameMatcher
extends AbstractShortNameMatcher {
    private final Pattern pattern;

    public RegexShortNameMatcher(ShortNameMatcher[] shortNameMatchers, int index, String wildcardExpression) {
        super(shortNameMatchers, index);
        String regex = wildcardExpression.replace("*", ".*").replace("$", "\\$");
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public ShortNameMatcher match(String shortName) {
        if (this.pattern.matcher(shortName).matches()) {
            return this.next();
        }
        return MissShortNameMatcher.MISS;
    }

    public String toString() {
        return this.pattern.toString().replace("\\$", "$").replace(".*", "*");
    }
}

