/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.partitioning;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.util.Predicate;
import de.spricom.dessert.util.Predicates;

public final class ClazzPredicates {
    public static final Predicate<Clazz> EACH = Predicates.any();
    public static final Predicate<Clazz> PUBLIC = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isPublic();
        }
    };
    public static final Predicate<Clazz> FINAL = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isFinal();
        }
    };
    public static final Predicate<Clazz> SUPER = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isSuper();
        }
    };
    public static final Predicate<Clazz> INTERFACE = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isInterface();
        }
    };
    public static final Predicate<Clazz> ABSTRACT = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isAbstract();
        }
    };
    public static final Predicate<Clazz> SYNTHETIC = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isSynthetic();
        }
    };
    public static final Predicate<Clazz> ANNOTATION = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isAnnotation();
        }
    };
    public static final Predicate<Clazz> ENUM = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getClassFile().isEnum();
        }
    };
    public static final Predicate<Clazz> INNER_TYPE = new Predicate<Clazz>(){

        @Override
        public boolean test(Clazz clazz) {
            return clazz.getName().lastIndexOf(36) != -1;
        }
    };

    public static Predicate<Clazz> matchesName(final String regex) {
        return new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return clazz.getName().matches(regex);
            }
        };
    }

    public static Predicate<Clazz> matchesSimpleName(final String regex) {
        return new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return clazz.getSimpleName().matches(regex);
            }
        };
    }

    public static Predicate<Clazz> implementsInterface(final String interfaceName) {
        return new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                for (String name : clazz.getClassFile().getInterfaces()) {
                    if (!name.equals(interfaceName)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Clazz> matchesClassFile(final Predicate<ClassFile> classFilePredicate) {
        return new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return classFilePredicate.test(clazz.getClassFile());
            }
        };
    }

    public static Predicate<Clazz> matches(final Predicate<Class<?>> classPredicate) {
        return new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return classPredicate.test(clazz.getClassImpl());
            }
        };
    }
}

