/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.partitioning;

import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.SlicePartitioner;
import de.spricom.dessert.util.Assertions;
import de.spricom.dessert.util.Predicate;
import java.util.LinkedList;
import java.util.List;

public class SlicePartitionerBuilder {
    private List<NamedPredicate> predicates = new LinkedList<NamedPredicate>();

    public NamedPredicate split(String name) {
        NamedPredicate predicate = new NamedPredicate(name);
        this.predicates.add(predicate);
        return predicate;
    }

    public SlicePartitioner build() {
        if (this.predicates.isEmpty()) {
            throw new IllegalArgumentException("No predicates given!");
        }
        return new SlicePartitioner(){

            @Override
            public String partKey(Clazz clazz) {
                for (NamedPredicate predicate : SlicePartitionerBuilder.this.predicates) {
                    if (!predicate.predicate.test(clazz)) continue;
                    return predicate.name;
                }
                return null;
            }
        };
    }

    class NamedPredicate {
        final String name;
        Predicate<Clazz> predicate;

        NamedPredicate(String name) {
            Assertions.notNull(name, "name");
            this.name = name;
        }

        public NamedPredicate by(Predicate<Clazz> predicate) {
            Assertions.notNull(predicate, "predicate");
            if (this.predicate != null) {
                throw new IllegalArgumentException("by() called twice for " + this);
            }
            this.predicate = predicate;
            return this;
        }

        public NamedPredicate split(String name) {
            return SlicePartitionerBuilder.this.split(name);
        }

        public SlicePartitioner build() {
            if (this.predicate == null) {
                throw new IllegalArgumentException("by() not called for " + this);
            }
            return SlicePartitionerBuilder.this.build();
        }

        public String toString() {
            return "predicate " + this.name;
        }
    }
}

