/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.matching.ShortNameMatcher;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.ClassVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ClassPackage {
    private final String packageName;
    private final ClassPackage parent;
    private final List<ClassPackage> subPackages = new ArrayList<ClassPackage>();
    private final List<ClassEntry> classes = new ArrayList<ClassEntry>();
    private List<ClassPackage> alternatives;

    protected ClassPackage() {
        this.packageName = "";
        this.parent = null;
    }

    public ClassPackage(ClassPackage parent, String packageName) {
        this.parent = parent;
        this.packageName = packageName;
        assert (this.getSubPackage(packageName) == null) : "Package " + packageName + " added twice.";
        parent.subPackages.add(this);
    }

    public ClassPackage getParent() {
        return this.parent;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public String getShortName() {
        if (this.parent == null) {
            return "";
        }
        String parentPackageName = this.getParent().getPackageName();
        if (parentPackageName.isEmpty()) {
            return this.packageName;
        }
        return this.packageName.substring(parentPackageName.length() + 1);
    }

    public ClassRoot getRoot() {
        return this.parent.getRoot();
    }

    public File getRootFile() {
        return this.getRoot().getRootFile();
    }

    public String toString() {
        return this.packageName;
    }

    public List<ClassPackage> getSubPackages() {
        return this.subPackages;
    }

    public ClassPackage getSubPackage(String packageName) {
        for (ClassPackage subPackage : this.subPackages) {
            if (!packageName.equals(subPackage.getPackageName())) continue;
            return subPackage;
        }
        return null;
    }

    public List<ClassEntry> getClasses() {
        return this.classes;
    }

    public void addClass(ClassEntry ce) {
        assert (this.getClass(ce.getClassname()) == null) : "Class " + ce.getClassname() + " added twice.";
        this.classes.add(ce);
    }

    public ClassEntry getClass(String classname) {
        for (ClassEntry ce : this.classes) {
            if (!classname.equals(ce.getClassname())) continue;
            return ce;
        }
        return null;
    }

    public List<ClassPackage> getAlternatives() {
        return this.alternatives;
    }

    void addAlternative(ClassPackage alt) {
        assert (alt.alternatives == null) : "alt.alternatives != null";
        if (this.alternatives == null) {
            this.alternatives = new LinkedList<ClassPackage>();
            this.alternatives.add(this);
        }
        assert (!this.alternatives.contains(alt)) : "alternatives.contains(alt)";
        this.alternatives.add(alt);
        alt.alternatives = this.alternatives;
    }

    protected final void traverse(ShortNameMatcher matcher, ClassVisitor visitor) {
        if (!matcher.isMatchPossible()) {
            return;
        }
        if (matcher.isLast()) {
            this.traverseClasses(matcher, visitor);
        } else {
            this.traverseSubPackages(matcher, visitor);
            if (matcher.isWildcard()) {
                this.traverse(matcher.next(), visitor);
            }
        }
    }

    private void traverseClasses(ShortNameMatcher matcher, ClassVisitor visitor) {
        for (ClassEntry clazz : this.classes) {
            if (!matcher.match(clazz.getShortName()).matches()) continue;
            visitor.visit(clazz);
        }
    }

    private void traverseSubPackages(ShortNameMatcher matcher, ClassVisitor visitor) {
        for (ClassPackage subPackage : this.subPackages) {
            subPackage.traverse(matcher.match(subPackage.getShortName()), visitor);
        }
    }
}

