/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassResolverCache;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.ClassVisitor;
import de.spricom.dessert.resolve.DirectoryRoot;
import de.spricom.dessert.resolve.JarRoot;
import de.spricom.dessert.resolve.TraversalRoot;
import de.spricom.dessert.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class ClassResolver
implements TraversalRoot {
    private static Logger log = Logger.getLogger(ClassResolver.class.getName());
    private final List<ClassRoot> path = new ArrayList<ClassRoot>(60);
    private final ClassResolverCache cache = new ClassResolverCache();
    private boolean frozen;

    public static ClassResolver of(String path) throws IOException {
        ClassResolver r = new ClassResolver();
        r.add(path);
        return r;
    }

    public static ClassResolver ofClassPath() throws IOException {
        ClassResolver r = new ClassResolver();
        r.addClassPath();
        return r;
    }

    public static ClassResolver ofClassPathWithoutJars() throws IOException {
        ClassResolver r = new ClassResolver();
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (entry.endsWith(".jar")) continue;
            r.addFile(entry);
        }
        return r;
    }

    public static ClassResolver ofBootClassPath() throws IOException {
        ClassResolver r = new ClassResolver();
        r.addBootClassPath();
        return r;
    }

    public static ClassResolver ofClassPathAndBootClassPath() throws IOException {
        ClassResolver r = new ClassResolver();
        r.addClassPath();
        r.addBootClassPath();
        return r;
    }

    public void addClassPath() throws IOException {
        this.add(System.getProperty("java.class.path"));
    }

    public void addBootClassPath() throws IOException {
        String path = System.getProperty("sun.boot.class.path");
        if (path != null) {
            this.add(path);
        }
    }

    public void add(String path) throws IOException {
        for (String entry : path.split(File.pathSeparator)) {
            this.addFile(entry);
        }
    }

    private void addFile(String filename) throws IOException {
        this.add(new File(filename));
    }

    public void add(File file) throws IOException {
        if (!file.exists()) {
            log.warning("Does not exist: " + file.getAbsolutePath());
        } else if (this.getRoot(file) != null) {
            log.warning("Already on path: " + file.getAbsolutePath());
        } else if (file.isDirectory()) {
            this.addRoot(new DirectoryRoot(file));
        } else if (file.isFile() && file.getName().endsWith(".jar")) {
            this.addRoot(new JarRoot(file));
        } else {
            log.warning("Don't know how to process: " + file.getAbsolutePath());
        }
    }

    public void addRoot(ClassRoot root) throws IOException {
        if (this.frozen) {
            throw new IllegalStateException("Cannot add root to a frozen ClassResolver.");
        }
        this.path.add(root);
        root.scan(this.cache);
    }

    public void freeze() {
        this.frozen = true;
    }

    public ClassRoot getRoot(File file) {
        for (ClassRoot root : this.path) {
            if (!root.getRootFile().equals(file)) continue;
            return root;
        }
        return null;
    }

    public ClassPackage getPackage(String packageName) {
        return this.cache.getPackage(packageName);
    }

    public ClassPackage getPackage(File root, String packageName) {
        ClassPackage pckg = this.getPackage(packageName);
        if (pckg == null) {
            return null;
        }
        if (root.equals(pckg.getRootFile())) {
            return pckg;
        }
        if (pckg.getAlternatives() != null) {
            for (ClassPackage alt : pckg.getAlternatives()) {
                if (!root.equals(alt.getRootFile())) continue;
                return alt;
            }
        }
        return null;
    }

    public ClassEntry getClassEntry(String classname) {
        return this.cache.getClassEntry(classname);
    }

    public ClassEntry getClassEntry(File root, String classname) {
        ClassEntry ce = this.getClassEntry(classname);
        if (ce == null) {
            return null;
        }
        if (root.equals(ce.getPackage().getRootFile())) {
            return ce;
        }
        if (ce.getAlternatives() != null) {
            for (ClassEntry alt : ce.getAlternatives()) {
                if (!root.equals(alt.getPackage().getRootFile())) continue;
                return alt;
            }
        }
        return null;
    }

    @Override
    public void traverse(NamePattern pattern, ClassVisitor visitor) {
        for (ClassRoot classRoot : this.path) {
            classRoot.traverse(pattern, visitor);
        }
    }

    public Set<File> getRootFiles() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return true;
            }
        });
    }

    public Set<File> getRootJars() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return !t.isDirectory();
            }
        });
    }

    public Set<File> getRootDirs() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return t.isDirectory();
            }
        });
    }

    public Set<File> getRootFiles(Predicate<File> predicate) {
        HashSet<File> files = new HashSet<File>();
        for (ClassRoot cr : this.path) {
            if (!predicate.test(cr.getRootFile())) continue;
            files.add(cr.getRootFile());
        }
        return files;
    }

    public Map<String, List<ClassEntry>> getDuplicates() {
        return this.cache.getDuplicates();
    }

    public int getPackageCount() {
        return this.cache.getPackageCount();
    }

    public int getClassCount() {
        return this.cache.getClassCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (File root : this.getRootFiles()) {
            if (sb.length() == 0) {
                sb.append("classpath ");
            } else {
                sb.append(File.pathSeparator);
            }
            sb.append(root.getAbsolutePath());
        }
        return sb.toString();
    }
}

