/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClassResolverCache
implements ClassCollector {
    private final Map<String, ClassPackage> packages = new HashMap<String, ClassPackage>(3000);
    private final Map<String, ClassEntry> classes = new HashMap<String, ClassEntry>(60000);
    private final Map<String, List<ClassEntry>> duplicates = new HashMap<String, List<ClassEntry>>();

    ClassResolverCache() {
    }

    @Override
    public void addPackage(ClassPackage pckg) {
        String pn = pckg.getPackageName();
        ClassPackage prev = this.packages.get(pn);
        if (prev == null) {
            this.packages.put(pn, pckg);
        } else {
            prev.addAlternative(pckg);
        }
    }

    @Override
    public void addClass(ClassEntry ce) {
        String cn = ce.getClassname();
        ClassEntry prev = this.classes.get(cn);
        if (prev == null) {
            this.classes.put(cn, ce);
        } else {
            prev.addAlternative(ce);
            this.duplicates.put(cn, prev.getAlternatives());
        }
    }

    ClassPackage getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    ClassEntry getClassEntry(String classname) {
        return this.classes.get(classname);
    }

    Map<String, List<ClassEntry>> getDuplicates() {
        return this.duplicates;
    }

    int getPackageCount() {
        return this.packages.size();
    }

    int getClassCount() {
        return this.classes.size();
    }
}

