/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.DirectoryClassEntry;
import java.io.File;
import java.io.IOException;

final class DirectoryRoot
extends ClassRoot {
    public DirectoryRoot(File dir) {
        super(dir);
    }

    @Override
    protected void scan(ClassCollector collector) throws IOException {
        this.scan(collector, this, this.getRootFile(), "");
    }

    private void scan(ClassCollector collector, ClassPackage pckg, File dir, String prefix) throws IOException {
        collector.addPackage(pckg);
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                String packageName = prefix + file.getName();
                ClassPackage subPackage = new ClassPackage(pckg, packageName);
                this.scan(collector, subPackage, file, packageName + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            DirectoryClassEntry classEntry = new DirectoryClassEntry(pckg, file);
            pckg.addClass(classEntry);
            collector.addClass(classEntry);
        }
    }
}

