/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.VersionsHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class JarClassEntry
extends ClassEntry {
    private final JarFile jarFile;
    private final JarEntry jarEntry;

    JarClassEntry(ClassPackage pckg, JarFile jarFile, JarEntry jarEntry) {
        super(JarClassEntry.classname(jarEntry), pckg);
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
    }

    private static String classname(JarEntry jarEntry) {
        String cn = VersionsHelper.removeVersionPrefix(jarEntry.getName());
        return cn.substring(0, cn.length() - ".class".length()).replace('/', '.');
    }

    @Override
    public ClassFile resolveClassFile() {
        InputStream is = null;
        try {
            ClassFile cf;
            is = this.jarFile.getInputStream(this.jarEntry);
            ClassFile classFile = cf = new ClassFile(is);
            return classFile;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read " + this.jarEntry.getName() + " from " + this.jarFile.getName(), ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot close stream after reading " + this.jarEntry.getName() + " from " + this.jarFile.getName(), ex);
                }
            }
        }
    }

    @Override
    public URI getURI() {
        String uri = "jar:" + new File(this.jarFile.getName()).toURI().toASCIIString() + "!/" + this.jarEntry.getName();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Cannot create URI from '" + uri + "'", ex);
        }
    }
}

