/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.JarClassEntry;
import de.spricom.dessert.resolve.VersionsHelper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class JarRoot
extends ClassRoot {
    public JarRoot(File jarFile) throws IOException {
        super(jarFile);
    }

    @Override
    protected void scan(ClassCollector collector) throws IOException {
        HashMap<String, ClassPackage> packages = new HashMap<String, ClassPackage>();
        packages.put("", this);
        collector.addPackage(this);
        JarFile jarFile = new JarFile(this.getRootFile());
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().startsWith("META-INF/")) continue;
            this.addClass(collector, packages, jarFile, entry);
        }
    }

    private void addClass(ClassCollector collector, Map<String, ClassPackage> packages, JarFile jarFile, JarEntry entry) throws IOException {
        ClassPackage pckg = this.ensurePackage(collector, packages, this.packageName(entry));
        JarClassEntry ce = new JarClassEntry(pckg, jarFile, entry);
        pckg.addClass(ce);
        collector.addClass(ce);
    }

    private String packageName(JarEntry entry) {
        String path = VersionsHelper.removeVersionPrefix(entry.getName());
        return this.packageName(path, '/').replace('/', '.');
    }

    private ClassPackage ensurePackage(ClassCollector collector, Map<String, ClassPackage> packages, String packageName) {
        ClassPackage pckg = packages.get(packageName);
        if (pckg != null) {
            return pckg;
        }
        ClassPackage parent = this.ensurePackage(collector, packages, this.parentPackageName(packageName));
        pckg = new ClassPackage(parent, packageName);
        collector.addPackage(pckg);
        packages.put(packageName, pckg);
        return pckg;
    }

    private String parentPackageName(String packageName) {
        return this.packageName(packageName, '.');
    }

    private String packageName(String name, char separator) {
        int index = name.lastIndexOf(separator);
        if (index == -1) {
            return "";
        }
        String packageName = name.substring(0, index);
        return packageName;
    }
}

