/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassResolver;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.slicing.AbstractRootSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.ResolveException;
import de.spricom.dessert.slicing.Root;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Classpath
extends AbstractRootSlice {
    private static final Logger log = Logger.getLogger(Classpath.class.getName());
    private static ClassResolver defaultResolver;
    private final ClassResolver resolver;
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();

    public Classpath() {
        this(Classpath.getDefaultResolver());
    }

    public Classpath(ClassResolver resolver) {
        super(resolver);
        this.resolver = resolver;
        resolver.freeze();
    }

    private static ClassResolver getDefaultResolver() {
        if (defaultResolver == null) {
            try {
                defaultResolver = ClassResolver.ofClassPathAndBootClassPath();
            }
            catch (IOException ex) {
                throw new ResolveException("Unable to access classes on classpath.", ex);
            }
        }
        return defaultResolver;
    }

    Clazz asClazz(ClassEntry ce) {
        Clazz se = this.classes.get(ce.getClassname());
        if (se == null) {
            se = new Clazz(this, ce);
            this.classes.put(ce.getClassname(), se);
            return se;
        }
        Clazz alt = se.getAlternative(ce);
        return alt;
    }

    public Clazz asClazz(String classname) {
        Clazz se = this.classes.get(classname);
        if (se == null) {
            se = this.resolveClazz(classname);
            if (se == null) {
                se = this.loadClass(classname);
            }
            if (se == null) {
                se = this.undefined(classname);
            }
            this.classes.put(classname, se);
        }
        return se;
    }

    public Clazz asClazz(Class<?> clazz) {
        Clazz se = this.classes.get(clazz.getName());
        if (se == null) {
            se = this.createClazz(clazz);
            this.classes.put(clazz.getName(), se);
        }
        return se;
    }

    private Clazz resolveClazz(String classname) {
        ClassEntry resolverEntry = this.resolver.getClassEntry(classname);
        if (resolverEntry == null) {
            return null;
        }
        return new Clazz(this, resolverEntry);
    }

    private Clazz createClazz(Class<?> clazz) {
        try {
            return new Clazz(this, clazz);
        }
        catch (IOException ex) {
            throw new ResolveException("Cannot analyze " + clazz, ex);
        }
    }

    private Clazz loadClass(String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            return new Clazz(this, clazz);
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.FINE, "Cannot find " + classname, ex);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Cannot analyze " + classname, ex);
        }
        return null;
    }

    private Clazz undefined(String classname) {
        return new Clazz(this, classname);
    }

    public ConcreteSlice duplicates() {
        HashSet<Clazz> sliceEntries = new HashSet<Clazz>();
        for (List<ClassEntry> alternatives : this.resolver.getDuplicates().values()) {
            for (ClassEntry alternative : alternatives) {
                sliceEntries.add(this.asClazz(alternative));
            }
        }
        return new ConcreteSlice(sliceEntries);
    }

    public Root rootOf(Class<?> clazz) {
        return this.rootOfClass(clazz.getName());
    }

    public Root rootOfClass(String classname) {
        ClassEntry cf = this.resolver.getClassEntry(classname);
        if (cf == null) {
            throw new IllegalArgumentException(classname + " not found within this classpath.");
        }
        return this.rootOf(cf.getPackage().getRoot());
    }

    public Root rootOf(File rootFile) {
        return this.rootOf(this.getClassRoot(rootFile));
    }

    private Root rootOf(ClassRoot root) {
        return new Root(root, this);
    }

    private ClassRoot getClassRoot(File rootFile) {
        if (rootFile == null) {
            throw new NullPointerException("rootFile must not be null");
        }
        ClassRoot root = this.resolver.getRoot(rootFile);
        if (root == null) {
            throw new IllegalArgumentException(rootFile + " has not been registered with this context.");
        }
        return root;
    }

    public Slice sliceOf(Class<?> ... classes) {
        if (classes.length == 0) {
            return Slices.EMPTY_SLICE;
        }
        if (classes.length == 1) {
            return this.asClazz(classes[0]);
        }
        HashSet<Clazz> clazzes = new HashSet<Clazz>();
        for (Class<?> clazz : classes) {
            clazzes.add(this.asClazz(clazz));
        }
        return new ConcreteSlice(clazzes);
    }

    public Slice sliceOf(String ... classnames) {
        if (classnames.length == 0) {
            return Slices.EMPTY_SLICE;
        }
        if (classnames.length == 1) {
            return this.asClazz(classnames[0]);
        }
        HashSet<Clazz> clazzes = new HashSet<Clazz>();
        for (String classname : classnames) {
            clazzes.add(this.asClazz(classname));
        }
        return new ConcreteSlice(clazzes);
    }

    @Override
    Classpath getClasspath() {
        return this;
    }

    @Override
    boolean isConcrete() {
        return false;
    }
}

