/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Concrete;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.ResolveException;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.util.ClassUtils;
import de.spricom.dessert.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public final class Clazz
extends AbstractSlice
implements Comparable<Clazz>,
Concrete {
    private static final Logger log = Logger.getLogger(Clazz.class.getName());
    public static final Clazz UNDEFINED = new Clazz();
    private final Classpath classpath;
    private final String className;
    private final ClassFile classFile;
    private final ClassEntry classEntry;
    private Class<?> classImpl;
    private URI uri;
    private Clazz superclass;
    private List<Clazz> implementedInterfaces;
    private ConcreteSlice dependencies;
    private List<Clazz> alternatives;

    private Clazz() {
        this.classpath = null;
        this.className = "undefined";
        this.classFile = null;
        this.classEntry = null;
        this.superclass = this;
        this.implementedInterfaces = Collections.emptyList();
        this.dependencies = ConcreteSlice.EMPTY_SLICE;
        this.alternatives = Collections.emptyList();
    }

    Clazz(Classpath classpath, ClassEntry classEntry) {
        assert (classpath != null) : "context == null";
        assert (classEntry != null) : "classEntry == null";
        this.classpath = classpath;
        this.classFile = classEntry.getClassfile();
        this.className = this.classFile.getThisClass();
        this.classEntry = classEntry;
        if (classEntry.getAlternatives() != null) {
            for (ClassEntry alternative : classEntry.getAlternatives()) {
                if (classEntry == alternative) continue;
                new Clazz(this, alternative);
            }
        }
    }

    Clazz(Clazz alternative, ClassEntry classEntry) {
        assert (alternative != null) : "alternative == null";
        assert (classEntry != null) : "classEntry == null";
        this.classpath = alternative.classpath;
        this.classEntry = classEntry;
        this.classFile = classEntry.getClassfile();
        this.className = this.classFile.getThisClass();
        if (alternative.alternatives == null) {
            alternative.alternatives = new LinkedList<Clazz>();
            alternative.alternatives.add(alternative);
        }
        this.alternatives = alternative.alternatives;
        this.alternatives.add(this);
    }

    Clazz(Classpath classpath, Class<?> classImpl) throws IOException {
        assert (classpath != null) : "context == null";
        assert (classImpl != null) : "clazz == null";
        this.classpath = classpath;
        this.classImpl = classImpl;
        this.classEntry = null;
        this.classFile = new ClassFile(classImpl);
        this.className = this.classFile.getThisClass();
    }

    Clazz(Classpath classpath, String className) {
        assert (classpath != null) : "context == null";
        assert (className != null) : "className == null";
        this.classpath = classpath;
        this.classEntry = null;
        this.classFile = null;
        this.className = className;
        this.superclass = UNDEFINED;
        this.implementedInterfaces = Collections.emptyList();
        this.dependencies = ConcreteSlice.EMPTY_SLICE;
        this.alternatives = Collections.emptyList();
    }

    public File getRootFile() {
        if (this.classEntry != null) {
            return this.classEntry.getPackage().getRootFile();
        }
        if (this.classImpl != null) {
            return ClassUtils.getRootFile(this.classImpl);
        }
        return null;
    }

    public String getPackageName() {
        if (this.classEntry != null) {
            return this.classEntry.getPackage().getPackageName();
        }
        if (this.classImpl != null) {
            return this.classImpl.getPackage().getName();
        }
        int index = this.className.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.className.substring(0, index);
    }

    @Override
    public Slice slice(Predicate<Clazz> predicate) {
        return predicate.test(this) ? this : Slices.EMPTY_SLICE;
    }

    @Override
    public boolean contains(Clazz clazz) {
        return this.equals(clazz);
    }

    @Override
    public Set<Clazz> getClazzes() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clazz other = (Clazz)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.getURI().equals(other.getURI());
    }

    @Override
    public int compareTo(Clazz o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "clazz " + this.className;
    }

    public boolean isUnknown() {
        return this.classFile == null;
    }

    public Class<?> getClassImpl() {
        if (this.classImpl == null && !this.isUnknown()) {
            try {
                this.classImpl = Class.forName(this.className);
                if (!this.getURI().equals(ClassUtils.getURI(this.classImpl))) {
                    log.warning("Loaded class " + ClassUtils.getURI(this.classImpl) + " for entry " + this.getURI() + "!");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ResolveException("Unable to load " + this.className, ex);
            }
        }
        return this.classImpl;
    }

    public Clazz getSuperclass() {
        if (this.superclass == null && this.classFile != null) {
            this.superclass = this.classpath.asClazz(this.classFile.getSuperClass());
        }
        return this.superclass;
    }

    public List<Clazz> getImplementedInterfaces() {
        if (this.implementedInterfaces == null && this.classFile != null) {
            this.implementedInterfaces = new ArrayList<Clazz>(this.classFile.getInterfaces().length);
            for (String in : this.classEntry.getClassfile().getInterfaces()) {
                this.implementedInterfaces.add(this.classpath.asClazz(in));
            }
        }
        return this.implementedInterfaces;
    }

    @Override
    public ConcreteSlice getDependencies() {
        if (this.dependencies == null && this.classFile != null) {
            HashSet<Clazz> deps = new HashSet<Clazz>(this.classFile.getDependentClasses().size());
            for (String cn : this.classFile.getDependentClasses()) {
                deps.add(this.classpath.asClazz(cn));
            }
            this.dependencies = new ConcreteSlice(deps);
        }
        return this.dependencies;
    }

    public List<Clazz> getAlternatives() {
        if (this.alternatives == null) {
            return Collections.singletonList(this);
        }
        return this.alternatives;
    }

    Clazz getAlternative(ClassEntry ce) {
        if (this.matches(ce)) {
            return this;
        }
        if (this.alternatives != null) {
            for (Clazz alt : this.alternatives) {
                if (!alt.matches(ce)) continue;
                return alt;
            }
        }
        return null;
    }

    private boolean matches(ClassEntry ce) {
        if (this.classEntry != null) {
            return this.classEntry == ce;
        }
        return this.getURI().equals(ce.getURI());
    }

    public String getName() {
        return this.className;
    }

    public String getSimpleName() {
        int dollarIndex = this.className.lastIndexOf(36);
        if (dollarIndex > 0) {
            String name = this.className.substring(dollarIndex + 1);
            if (name.matches("\\d+")) {
                return "";
            }
            return name;
        }
        int dotIndex = this.className.lastIndexOf(46);
        return this.className.substring(dotIndex + 1);
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.classEntry != null) {
            this.uri = this.classEntry.getURI();
            return this.uri;
        }
        if (this.classImpl != null) {
            this.uri = ClassUtils.getURI(this.classImpl);
        } else {
            String unknown = "dessert:unknown:" + this.className;
            try {
                this.uri = new URI(unknown);
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("Cannot convert '" + unknown + "' to URI", ex);
            }
        }
        assert (this.uri != null) : "URI has not been determined";
        return this.uri;
    }
}

