/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ResolveException;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.util.Predicate;
import de.spricom.dessert.util.Predicates;
import java.util.HashSet;
import java.util.Set;

final class DerivedSlice
extends AbstractSlice {
    private final NamePattern namePattern;
    private final Predicate<Clazz> predicate;
    private final Set<Clazz> cache = new HashSet<Clazz>();

    private DerivedSlice(NamePattern namePattern, Predicate<Clazz> predicate) {
        this.namePattern = namePattern;
        this.predicate = predicate;
    }

    DerivedSlice(NamePattern namePattern) {
        this(namePattern, Predicates.any());
    }

    DerivedSlice(Predicate<Clazz> predicate) {
        this(NamePattern.ANY_NAME, predicate);
    }

    @Override
    public Slice slice(final Predicate<Clazz> predicate) {
        return new DerivedSlice(new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return DerivedSlice.this.contains(clazz) && predicate.test(clazz);
            }
        });
    }

    @Override
    public boolean contains(Clazz entry) {
        if (!this.namePattern.matches(entry.getName())) {
            return false;
        }
        if (this.cache.contains(entry)) {
            return true;
        }
        boolean member = this.predicate.test(entry);
        if (member) {
            this.cache.add(entry);
        }
        return member;
    }

    @Override
    public Set<Clazz> getClazzes() {
        throw new ResolveException("Cannot get classes for " + this);
    }

    public String toString() {
        if (this.namePattern == NamePattern.ANY_NAME) {
            return "slice from " + this.predicate;
        }
        return "slice " + this.namePattern;
    }
}

