/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassVisitor;
import de.spricom.dessert.resolve.TraversalRoot;
import de.spricom.dessert.slicing.AbstractClazzResolver;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ResolveException;
import java.util.Set;

final class NamePatternClazzResolver
extends AbstractClazzResolver
implements ClassVisitor {
    private final NamePattern pattern;
    private final TraversalRoot root;

    NamePatternClazzResolver(Classpath cp, NamePattern pattern, TraversalRoot root) {
        super(cp);
        this.pattern = pattern;
        this.root = root;
    }

    @Override
    protected void resolve() {
        this.root.traverse(this.pattern, this);
    }

    @Override
    public void visit(ClassEntry ce) {
        this.add(ce);
    }

    @Override
    public Set<Clazz> getClazzes() {
        Set<Clazz> clazzes = super.getClazzes();
        if (clazzes.isEmpty() && this.pattern.isAny()) {
            throw new ResolveException("No classes found in " + this.root);
        }
        return clazzes;
    }

    public NamePatternClazzResolver filtered(NamePattern additionalPattern) {
        if (additionalPattern.isMoreConcreteThan(this.pattern)) {
            return new NamePatternClazzResolver(this.getClasspath(), additionalPattern, this.root);
        }
        return this;
    }
}

