/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.UnionSlice;
import java.util.Arrays;
import java.util.LinkedList;

public final class Slices {
    public static final ConcreteSlice EMPTY_SLICE = ConcreteSlice.EMPTY_SLICE;

    private Slices() {
    }

    public static Slice of(Iterable<? extends Slice> slices) {
        LinkedList<Slice> list = new LinkedList<Slice>();
        for (Slice slice : slices) {
            list.add(slice);
        }
        if (list.isEmpty()) {
            return EMPTY_SLICE;
        }
        if (list.size() == 1) {
            return (Slice)list.get(0);
        }
        return new UnionSlice(list);
    }

    public static Slice of(Slice ... slices) {
        if (slices.length == 0) {
            return EMPTY_SLICE;
        }
        if (slices.length == 1) {
            return slices[0];
        }
        return new UnionSlice(Arrays.asList(slices));
    }
}

