/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.util.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class UnionSlice
extends AbstractSlice {
    private final List<Slice> slices;
    private Boolean iterable;

    public UnionSlice(List<Slice> slices) {
        if (slices.size() < 2) {
            throw new IllegalArgumentException("Union must contain at least two slices");
        }
        this.slices = slices;
    }

    @Override
    public Slice slice(Predicate<Clazz> predicate) {
        ArrayList<Slice> derived = new ArrayList<Slice>(this.slices.size());
        for (Slice slice : this.slices) {
            derived.add(slice.slice(predicate));
        }
        return new UnionSlice(derived);
    }

    @Override
    public boolean contains(Clazz clazz) {
        for (Slice slice : this.slices) {
            if (!slice.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Clazz> getClazzes() {
        HashSet<Clazz> clazzes = new HashSet<Clazz>();
        for (Slice slice : this.slices) {
            clazzes.addAll(slice.getClazzes());
        }
        return clazzes;
    }
}

