package de.spricom.dessert.util;

/*-
 * #%L
 * Dessert Dependency Assertion Library for Java
 * %%
 * Copyright (C) 2017 - 2022 Hans Jörg Heßmann
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.util.LinkedList;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {}

    public static <T> List<T> filter(T[] array, Predicate<T> predicate) {
        List<T> matches = new LinkedList<T>();
        if (array == null) {
            return matches;
        }
        for (T element : array) {
            if (predicate.test(element)) {
                matches.add(element);
            }
        }
        return matches;
    }

    public static <T> T findFirst(T[] array, Predicate<T> predicate) {
        List<T> matches = filter(array, predicate);
        return matches.isEmpty() ? null : matches.get(0);
    }
}
