/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.assertions;

import de.spricom.dessert.assertions.CycleRenderer;
import de.spricom.dessert.assertions.DefaultCycleRenderer;
import de.spricom.dessert.assertions.DefaultIllegalDependenciesRenderer;
import de.spricom.dessert.assertions.IllegalDependencies;
import de.spricom.dessert.assertions.IllegalDependenciesRenderer;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.util.Dag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SliceAssert {
    private final Iterable<? extends Slice> slices;
    private final Slice union;
    private IllegalDependenciesRenderer violationsRenderer = new DefaultIllegalDependenciesRenderer();
    private CycleRenderer cycleRenderer = new DefaultCycleRenderer();

    SliceAssert(Iterable<? extends Slice> slices) {
        this.slices = slices;
        this.union = Slices.of(slices);
    }

    public SliceAssert renderWith(IllegalDependenciesRenderer renderer) {
        this.violationsRenderer = renderer;
        return this;
    }

    public SliceAssert renderCycleWith(CycleRenderer renderer) {
        this.cycleRenderer = renderer;
        return this;
    }

    public SliceAssert usesOnly(Iterable<Slice> others) {
        IllegalDependencies illegalDependencies = new IllegalDependencies();
        for (Clazz entry : this.union.getClazzes()) {
            for (Clazz dependency : entry.getDependencies().getClazzes()) {
                if (this.union.contains(dependency) || this.containsAny(others, dependency)) continue;
                illegalDependencies.add(entry, dependency);
            }
        }
        if (!illegalDependencies.isEmpty()) {
            throw new AssertionError((Object)this.violationsRenderer.render(illegalDependencies));
        }
        return this;
    }

    public SliceAssert useOnly(Iterable<Slice> others) {
        return this.usesOnly(others);
    }

    public SliceAssert usesOnly(Slice ... others) {
        return this.usesOnly(Arrays.asList(others));
    }

    public SliceAssert useOnly(Slice ... others) {
        return this.usesOnly(others);
    }

    public SliceAssert usesNot(Iterable<Slice> others) {
        IllegalDependencies illegalDependencies = new IllegalDependencies();
        this.addIllegalDependencies(illegalDependencies, this.union, others);
        if (!illegalDependencies.isEmpty()) {
            throw new AssertionError((Object)this.violationsRenderer.render(illegalDependencies));
        }
        return this;
    }

    public SliceAssert usesNot(Slice ... others) {
        return this.usesNot(Arrays.asList(others));
    }

    public SliceAssert doesNotUse(Iterable<Slice> others) {
        return this.usesNot(others);
    }

    public SliceAssert doesNotUse(Slice ... others) {
        return this.usesNot(others);
    }

    public SliceAssert doNotUse(Iterable<Slice> others) {
        return this.usesNot(others);
    }

    public SliceAssert doNotUse(Slice ... others) {
        return this.usesNot(others);
    }

    private void addIllegalDependencies(IllegalDependencies illegalDependencies, Slice slice, Iterable<Slice> illegals) {
        for (Clazz clazz : slice.getClazzes()) {
            for (Clazz dependency : clazz.getDependencies().getClazzes()) {
                if (!this.containsAny(illegals, dependency)) continue;
                illegalDependencies.add(clazz, dependency);
            }
        }
    }

    private boolean containsAny(Iterable<Slice> slices, Clazz clazz) {
        for (Slice slice : slices) {
            if (!slice.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    public SliceAssert isCycleFree() {
        Map<Slice, ConcreteSlice> dependencies = this.mapDependencies();
        Dag<Slice> dag = new Dag<Slice>();
        for (Slice slice : this.slices) {
            for (Slice slice2 : this.slices) {
                if (slice == slice2 || !slice.uses(slice2)) continue;
                dag.addEdge(slice, slice2);
            }
        }
        if (!dag.isCycleFree()) {
            String cycle = this.renderCycle(dag);
            throw new AssertionError((Object)cycle);
        }
        return this;
    }

    public SliceAssert areCycleFree() {
        return this.isCycleFree();
    }

    public SliceAssert isLayeredStrict() {
        IllegalDependencies illegalDependencies = new IllegalDependencies();
        List<Slice> list = this.asList();
        if (list.size() < 2) {
            return this;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > 0) {
                this.addIllegalDependencies(illegalDependencies, list.get(i), list.subList(0, i));
            }
            if (i + 2 >= list.size()) continue;
            this.addIllegalDependencies(illegalDependencies, list.get(i), list.subList(i + 2, list.size()));
        }
        if (!illegalDependencies.isEmpty()) {
            throw new AssertionError((Object)this.violationsRenderer.render(illegalDependencies));
        }
        return this;
    }

    public SliceAssert areLayeredStrict() {
        return this.isLayeredStrict();
    }

    public SliceAssert isLayeredRelaxed() {
        IllegalDependencies illegalDependencies = new IllegalDependencies();
        List<Slice> list = this.asList();
        if (list.size() < 2) {
            return this;
        }
        for (int i = list.size() - 1; i > 0; --i) {
            this.addIllegalDependencies(illegalDependencies, list.get(i), list.subList(0, i));
        }
        if (!illegalDependencies.isEmpty()) {
            throw new AssertionError((Object)this.violationsRenderer.render(illegalDependencies));
        }
        return this;
    }

    public SliceAssert areLayeredRelaxed() {
        return this.isLayeredRelaxed();
    }

    private List<Slice> asList() {
        ArrayList<Slice> list = new ArrayList<Slice>();
        for (Slice slice : this.slices) {
            list.add(slice);
        }
        return list;
    }

    private Map<Slice, ConcreteSlice> mapDependencies() {
        HashMap<Slice, ConcreteSlice> dependencies = new HashMap<Slice, ConcreteSlice>();
        for (Slice slice : this.slices) {
            dependencies.put(slice, slice.getDependencies());
        }
        return dependencies;
    }

    private String renderCycle(Dag<Slice> dag) {
        return this.cycleRenderer.renderCycle(dag);
    }
}

