/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile;

import de.spricom.dessert.classfile.FieldInfo;
import de.spricom.dessert.classfile.MemberInfo;
import de.spricom.dessert.classfile.MethodInfo;
import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.attribute.Attributes;
import de.spricom.dessert.classfile.attribute.DeprecatedAttribute;
import de.spricom.dessert.classfile.attribute.EnclosingMethodAttribute;
import de.spricom.dessert.classfile.attribute.InnerClass;
import de.spricom.dessert.classfile.attribute.InnerClassesAttribute;
import de.spricom.dessert.classfile.attribute.NestHostAttribute;
import de.spricom.dessert.classfile.attribute.NestMembersAttribute;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ClassFile {
    public static final int MAGIC = -889275714;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MODULE = 32768;
    private final int minorVersion;
    private final int majorVersion;
    private final ConstantPool constantPool;
    private final int accessFlags;
    private final String thisClass;
    private final String superClass;
    private String[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private final AttributeInfo[] attributes;

    public ClassFile(Class<?> clazz) throws IOException {
        this(ClassFile.open(clazz));
    }

    private static InputStream open(Class<?> clazz) {
        InputStream is = clazz.getResourceAsStream("/" + clazz.getName().replace('.', '/') + ".class");
        assert (is != null) : "No file found for " + clazz;
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile(InputStream in) throws IOException {
        BufferedInputStream bi = new BufferedInputStream(in);
        try {
            DataInputStream is = new DataInputStream(bi);
            if (-889275714 != is.readInt()) {
                throw new IOException("Not a class file.");
            }
            this.minorVersion = is.readUnsignedShort();
            this.majorVersion = is.readUnsignedShort();
            this.constantPool = new ConstantPool(is);
            this.accessFlags = is.readUnsignedShort();
            this.thisClass = this.constantPool.getConstantClassName(is.readUnsignedShort());
            this.superClass = this.constantPool.getConstantClassName(is.readUnsignedShort());
            this.readInterfaces(is);
            this.readFields(is);
            this.readMethods(is);
            this.attributes = AttributeInfo.readAttributes(is, this.constantPool, AttributeInfo.AttributeContext.CLASS);
            if (is.read() != -1) {
                throw new IOException("EOF not reached!");
            }
        }
        finally {
            bi.close();
        }
    }

    private void readInterfaces(DataInputStream is) throws IOException {
        int interfacesCount = is.readUnsignedShort();
        this.interfaces = new String[interfacesCount];
        for (int i = 0; i < interfacesCount; ++i) {
            this.interfaces[i] = this.constantPool.getConstantClassName(is.readUnsignedShort());
        }
    }

    private void readFields(DataInputStream is) throws IOException {
        int fieldCount = is.readUnsignedShort();
        this.fields = new FieldInfo[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            this.fields[i] = new FieldInfo();
            this.readMember(this.fields[i], is, AttributeInfo.AttributeContext.FIELD);
        }
    }

    private void readMethods(DataInputStream is) throws IOException {
        int methodCount = is.readUnsignedShort();
        this.methods = new MethodInfo[methodCount];
        for (int i = 0; i < methodCount; ++i) {
            this.methods[i] = new MethodInfo();
            this.readMember(this.methods[i], is, AttributeInfo.AttributeContext.METHOD);
        }
    }

    private void readMember(MemberInfo member, DataInputStream is, AttributeInfo.AttributeContext context) throws IOException {
        member.setAccessFlags(is.readUnsignedShort());
        member.setName(this.readString(is));
        member.setDescriptor(this.readString(is));
        member.setAttributes(AttributeInfo.readAttributes(is, this.constantPool, context));
    }

    private String readString(DataInputStream is) throws IOException {
        return this.constantPool.getUtf8String(is.readUnsignedShort());
    }

    public Set<String> getDependentClasses() {
        TreeSet<String> classNames = new TreeSet<String>();
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.addDependentClassNames(classNames);
        }
        for (MemberInfo memberInfo : this.methods) {
            ((MethodInfo)memberInfo).addDependentClassNames(classNames);
        }
        for (DependencyHolder dependencyHolder : this.attributes) {
            ((AttributeInfo)dependencyHolder).addDependentClassNames(classNames);
        }
        this.constantPool.addDependentClassNames(classNames);
        classNames.remove(this.thisClass);
        return classNames;
    }

    public String dumpConstantPool() {
        return this.constantPool.dumpConstantPool();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constantPool.dumpConstantPool());
        String indent = "\t";
        sb.append("Interfaces:\n");
        for (String ifc : this.getInterfaces()) {
            sb.append(indent).append(ifc).append("\n");
        }
        sb.append("Fields:\n");
        for (FieldInfo field : this.getFields()) {
            sb.append(indent).append(field).append("\n");
            this.dump(field.getAttributes(), sb, indent + indent);
        }
        sb.append("Methods:\n");
        for (MethodInfo method : this.getMethods()) {
            sb.append(indent).append(method).append("\n");
            this.dump(method.getAttributes(), sb, indent + indent);
        }
        sb.append("Class attributes:\n");
        this.dump(this.getAttributes(), sb, indent);
        sb.append("Dependent classes:\n");
        for (String dependentClass : this.getDependentClasses()) {
            sb.append("  ").append(dependentClass).append("\n");
        }
        return sb.toString();
    }

    private void dump(AttributeInfo[] attributes, StringBuilder sb, String indent) {
        for (AttributeInfo attribute : attributes) {
            sb.append(indent).append("attribute: ").append(attribute).append("\n");
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getThisClass() {
        return this.thisClass;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public boolean isModule() {
        return (this.accessFlags & 0x8000) != 0;
    }

    public String getSimpleName() {
        List<InnerClassesAttribute> innerClassesAttributes = Attributes.filter(this.attributes, InnerClassesAttribute.class);
        if (!innerClassesAttributes.isEmpty()) {
            for (InnerClass innerClass : innerClassesAttributes.get(0).getInnerClasses()) {
                if (!this.thisClass.equals(innerClass.getInnerClassName())) continue;
                String simpleName = innerClass.getSimpleName();
                return simpleName == null ? "" : simpleName;
            }
        }
        return this.thisClass.substring(this.thisClass.lastIndexOf(46) + 1);
    }

    public boolean isInnerClass() {
        if (this.thisClass.indexOf(36) == -1) {
            return false;
        }
        if (this.majorVersion >= 55) {
            return !Attributes.filter(this.attributes, NestHostAttribute.class).isEmpty();
        }
        if (!Attributes.filter(this.attributes, EnclosingMethodAttribute.class).isEmpty()) {
            return true;
        }
        List<InnerClassesAttribute> innerClassesAttributes = Attributes.filter(this.attributes, InnerClassesAttribute.class);
        if (innerClassesAttributes.isEmpty()) {
            return false;
        }
        for (InnerClass innerClass : innerClassesAttributes.get(0).getInnerClasses()) {
            if (!this.thisClass.equals(innerClass.getInnerClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isNestHost() {
        if (this.majorVersion >= 55) {
            List<NestMembersAttribute> nestMembersAttributes = Attributes.filter(this.attributes, NestMembersAttribute.class);
            return !nestMembersAttributes.isEmpty();
        }
        List<InnerClassesAttribute> innerClassesAttributes = Attributes.filter(this.attributes, InnerClassesAttribute.class);
        if (innerClassesAttributes.isEmpty()) {
            return false;
        }
        int dollarIndex = this.thisClass.indexOf(36);
        boolean hasInnerClass = false;
        for (InnerClass innerClass : innerClassesAttributes.get(0).getInnerClasses()) {
            if (this.thisClass.equals(innerClass.getInnerClassName())) {
                return false;
            }
            if (!innerClass.getInnerClassName().startsWith(this.thisClass)) continue;
            if (dollarIndex == -1) {
                return true;
            }
            hasInnerClass = true;
        }
        return hasInnerClass;
    }

    public String getNestHost() {
        if (this.majorVersion >= 55) {
            List<NestHostAttribute> nestHostAttributes = Attributes.filter(this.attributes, NestHostAttribute.class);
            return nestHostAttributes.isEmpty() ? null : nestHostAttributes.get(0).getHostClassName();
        }
        List<InnerClassesAttribute> innerClassesAttributes = Attributes.filter(this.attributes, InnerClassesAttribute.class);
        if (innerClassesAttributes.isEmpty()) {
            return null;
        }
        List<EnclosingMethodAttribute> enclosingMethodAttributes = Attributes.filter(this.attributes, EnclosingMethodAttribute.class);
        String outerName = enclosingMethodAttributes.isEmpty() ? this.thisClass : enclosingMethodAttributes.get(0).getEnclosingClassname();
        InnerClass[] innerClasses = innerClassesAttributes.get(0).getInnerClasses();
        boolean outerMost = false;
        while (!outerMost) {
            outerMost = true;
            for (InnerClass innerClass : innerClasses) {
                if (!outerName.equals(innerClass.getInnerClassName()) || innerClass.getOuterClassName() == null) continue;
                outerName = innerClass.getOuterClassName();
                outerMost = false;
            }
        }
        if (this.thisClass.equals(outerName)) {
            for (InnerClass innerClass : innerClasses) {
                if (!this.thisClass.equals(innerClass.getOuterClassName()) && !innerClass.getInnerClassName().startsWith(this.thisClass)) continue;
                return this.thisClass;
            }
            return null;
        }
        return outerName;
    }

    public List<String> getNestMembers() {
        if (this.majorVersion >= 55) {
            List<NestMembersAttribute> nestMembersAttributes = Attributes.filter(this.attributes, NestMembersAttribute.class);
            if (nestMembersAttributes.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(nestMembersAttributes.get(0).getMembers());
        }
        List<InnerClassesAttribute> innerClassesAttributes = Attributes.filter(this.attributes, InnerClassesAttribute.class);
        if (innerClassesAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        InnerClass[] innerClasses = innerClassesAttributes.get(0).getInnerClasses();
        ArrayList<String> nestMembers = new ArrayList<String>(innerClasses.length);
        for (InnerClass innerClass : innerClasses) {
            if (!innerClass.getInnerClassName().startsWith(this.thisClass)) continue;
            nestMembers.add(innerClass.getInnerClassName());
        }
        return nestMembers;
    }

    public boolean isDeprecated() {
        return !Attributes.filter(this.attributes, DeprecatedAttribute.class).isEmpty();
    }
}

