/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.util.Set;

abstract class MemberInfo
implements DependencyHolder {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_public = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    private int accessFlags;
    private String name;
    private String descriptor;
    private AttributeInfo[] attributes;

    MemberInfo() {
    }

    protected boolean is(int accessFlag) {
        return (this.accessFlags & accessFlag) == accessFlag;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (AttributeInfo attribute : this.attributes) {
            attribute.addDependentClassNames(classNames);
        }
    }

    public abstract String getDeclaration();

    public String toString() {
        return this.getDeclaration();
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeInfo[] attributes) {
        this.attributes = attributes;
    }

    protected StringBuilder getDeclarationStringBuilder() {
        StringBuilder sb = new StringBuilder();
        if (this.is(1)) {
            sb.append("public ");
        } else if (this.is(4)) {
            sb.append("protected ");
        } else if (!this.is(2)) {
            sb.append("private ");
        }
        if (this.is(8)) {
            sb.append("static ");
        }
        if (this.is(16)) {
            sb.append("final ");
        }
        return sb;
    }
}

