/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile;

import de.spricom.dessert.classfile.MemberInfo;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.constpool.MethodType;
import java.util.Set;

public class MethodInfo
extends MemberInfo {
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    private MethodType methodType;

    public MethodType getMethodType() {
        if (this.methodType == null) {
            this.methodType = new MethodType(this.getDescriptor());
        }
        return this.methodType;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.getMethodType().addDependentClassNames(classNames);
        super.addDependentClassNames(classNames);
    }

    @Override
    public String getDeclaration() {
        FieldType[] parameterTypes;
        StringBuilder sb = this.getDeclarationStringBuilder();
        if (this.is(32)) {
            sb.append("synchronized ");
        }
        if (this.is(64)) {
            sb.append("bridge ");
        }
        if (this.is(128)) {
            sb.append("varargs ");
        }
        if (this.is(256)) {
            sb.append("native ");
        }
        if (this.is(1024)) {
            sb.append("abstract ");
        }
        if (this.is(2048)) {
            sb.append("strict ");
        }
        if (this.is(4096)) {
            sb.append("synthetic ");
        }
        sb.append(this.getMethodType().getReturnType().getDeclaration());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        int i = 1;
        for (FieldType parameterType : parameterTypes = this.getMethodType().getParameterTypes()) {
            sb.append(parameterType.getDeclaration());
            if (i < parameterTypes.length) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(");");
        return sb.toString();
    }
}

