/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.Annotation;
import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractAnnotationsAttribute
extends AttributeInfo {
    private final Annotation[] annotations;

    AbstractAnnotationsAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        is.readInt();
        this.annotations = new Annotation[is.readUnsignedShort()];
        for (int i = 0; i < this.annotations.length; ++i) {
            this.annotations[i] = new Annotation(is, constantPool);
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (Annotation annotation : this.annotations) {
            annotation.addDependentClassNames(classNames);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":");
        for (Annotation annotation : this.annotations) {
            sb.append("\n\t\t\t\t");
            sb.append(annotation);
        }
        return sb.toString();
    }
}

