/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.ElementValuePair;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class Annotation
implements DependencyHolder {
    private final FieldType type;
    private final ElementValuePair[] elementValuePairs;

    public Annotation(DataInputStream is, ConstantPool constantPool) throws IOException {
        this.type = constantPool.getFieldType(is.readUnsignedShort());
        this.elementValuePairs = new ElementValuePair[is.readUnsignedShort()];
        for (int i = 0; i < this.elementValuePairs.length; ++i) {
            this.elementValuePairs[i] = new ElementValuePair(is, constantPool);
        }
    }

    public FieldType getType() {
        return this.type;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.type.addDependentClassNames(classNames);
        for (ElementValuePair pair : this.elementValuePairs) {
            pair.addDependentClassNames(classNames);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("@").append(this.type.toString()).append("(");
        if (this.elementValuePairs.length > 0) {
            boolean first = true;
            for (ElementValuePair pair : this.elementValuePairs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(pair);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

