/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AnnotationDefaultAttribute;
import de.spricom.dessert.classfile.attribute.CodeAttribute;
import de.spricom.dessert.classfile.attribute.ConstantValueAttribute;
import de.spricom.dessert.classfile.attribute.DeprecatedAttribute;
import de.spricom.dessert.classfile.attribute.EnclosingMethodAttribute;
import de.spricom.dessert.classfile.attribute.ExceptionsAttribute;
import de.spricom.dessert.classfile.attribute.InnerClassesAttribute;
import de.spricom.dessert.classfile.attribute.ModuleAttribute;
import de.spricom.dessert.classfile.attribute.ModuleMainClassAttribute;
import de.spricom.dessert.classfile.attribute.ModulePackagesAttribute;
import de.spricom.dessert.classfile.attribute.NestHostAttribute;
import de.spricom.dessert.classfile.attribute.NestMembersAttribute;
import de.spricom.dessert.classfile.attribute.PermittedSubclassesAttribute;
import de.spricom.dessert.classfile.attribute.RecordAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.SignatureAttribute;
import de.spricom.dessert.classfile.attribute.SourceFileAttribute;
import de.spricom.dessert.classfile.attribute.SyntheticAttribute;
import de.spricom.dessert.classfile.attribute.UnknownAttribute;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public abstract class AttributeInfo
implements DependencyHolder {
    private final String name;
    private AttributeContext context;

    public static AttributeInfo[] readAttributes(DataInputStream is, ConstantPool constantPool, AttributeContext context) throws IOException {
        AttributeInfo[] attributes = new AttributeInfo[is.readUnsignedShort()];
        for (int i = 0; i < attributes.length; ++i) {
            String name = constantPool.getUtf8String(is.readUnsignedShort());
            attributes[i] = "ConstantValue".equals(name) ? new ConstantValueAttribute(name, is, constantPool) : ("Code".equals(name) ? new CodeAttribute(name, is, constantPool) : ("Exceptions".equals(name) ? new ExceptionsAttribute(name, is, constantPool) : ("InnerClasses".equals(name) ? new InnerClassesAttribute(name, is, constantPool) : ("EnclosingMethod".equals(name) ? new EnclosingMethodAttribute(name, is, constantPool) : ("Synthetic".equals(name) ? new SyntheticAttribute(name, is, constantPool) : ("Signature".equals(name) ? new SignatureAttribute(name, is, constantPool) : ("SourceFile".equals(name) ? new SourceFileAttribute(name, is, constantPool) : ("Deprecated".equals(name) ? new DeprecatedAttribute(name, is, constantPool) : ("RuntimeVisibleAnnotations".equals(name) ? new RuntimeVisibleAnnotationsAttribute(name, is, constantPool) : ("RuntimeInvisibleAnnotations".equals(name) ? new RuntimeInvisibleAnnotationsAttribute(name, is, constantPool) : ("RuntimeVisibleParameterAnnotations".equals(name) ? new RuntimeVisibleParameterAnnotationsAttribute(name, is, constantPool) : ("RuntimeInvisibleParameterAnnotations".equals(name) ? new RuntimeInvisibleParameterAnnotationsAttribute(name, is, constantPool) : ("RuntimeVisibleTypeAnnotations".equals(name) ? new RuntimeVisibleTypeAnnotationsAttribute(name, is, constantPool) : ("RuntimeInvisibleTypeAnnotations".equals(name) ? new RuntimeInvisibleTypeAnnotationsAttribute(name, is, constantPool) : ("AnnotationDefault".equals(name) ? new AnnotationDefaultAttribute(name, is, constantPool) : ("Module".equals(name) ? new ModuleAttribute(name, is, constantPool) : ("ModulePackages".equals(name) ? new ModulePackagesAttribute(name, is, constantPool) : ("ModuleMainClass".equals(name) ? new ModuleMainClassAttribute(name, is, constantPool) : ("NestHost".equals(name) ? new NestHostAttribute(name, is, constantPool) : ("NestMembers".equals(name) ? new NestMembersAttribute(name, is, constantPool) : ("Record".equals(name) ? new RecordAttribute(name, is, constantPool) : ("PermittedSubclasses".equals(name) ? new PermittedSubclassesAttribute(name, is, constantPool) : new UnknownAttribute(name, is)))))))))))))))))))))));
            attributes[i].context = context;
        }
        return attributes;
    }

    public AttributeInfo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected final void skipLength(DataInputStream is) throws IOException {
        is.readInt();
    }

    protected final String[] readClassNames(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        String[] classNames = new String[is.readUnsignedShort()];
        for (int i = 0; i < classNames.length; ++i) {
            String className = constantPool.getConstantClassName(is.readUnsignedShort());
            if (className == null) {
                throw new IllegalArgumentException("No classname at index " + i + " of " + name + " attribute");
            }
            classNames[i] = className;
        }
        return classNames;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
    }

    public AttributeContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.getName();
    }

    public static enum AttributeContext {
        CLASS,
        FIELD,
        METHOD,
        CODE,
        RECORD;

    }
}

