/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.Annotation;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.constpool.ConstantValue;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.constpool.MethodType;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class ElementValue
implements DependencyHolder {
    private final char tag;
    private ConstantValue<?> constantValue;
    private FieldType type;
    private Annotation annotation;
    private ElementValue[] values;

    public ElementValue(DataInputStream is, ConstantPool constantPool) throws IOException {
        this.tag = (char)is.readUnsignedByte();
        switch (this.tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                this.constantValue = constantPool.getConstantValue(is.readUnsignedShort());
                break;
            }
            case 'e': {
                this.type = constantPool.getFieldType(is.readUnsignedShort());
                this.constantValue = constantPool.getConstantValue(is.readUnsignedShort());
                break;
            }
            case 'c': {
                this.type = constantPool.getFieldType(is.readUnsignedShort());
                break;
            }
            case '@': {
                this.annotation = new Annotation(is, constantPool);
                break;
            }
            case '[': {
                this.values = new ElementValue[is.readUnsignedShort()];
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new ElementValue(is, constantPool);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ElementValue tag: " + this.tag);
            }
        }
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        if (this.type != null) {
            this.type.addDependentClassNames(classNames);
        }
        if (this.annotation != null) {
            this.annotation.addDependentClassNames(classNames);
        }
        if (this.values != null) {
            for (ElementValue value : this.values) {
                value.addDependentClassNames(classNames);
            }
        }
        if (this.tag == 's') {
            this.extractTypeFromString(classNames);
        }
    }

    private void extractTypeFromString(Set<String> classNames) {
        String descriptor = (String)this.constantValue.getValue();
        if (FieldType.isFieldDescriptor(descriptor)) {
            new FieldType(descriptor).addDependentClassNames(classNames);
        } else if (MethodType.isMethodDescriptor(descriptor)) {
            new MethodType(descriptor).addDependentClassNames(classNames);
        }
    }

    public char getTag() {
        return this.tag;
    }

    public ConstantValue<?> getConstantValue() {
        return this.constantValue;
    }

    public FieldType getType() {
        return this.type;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public ElementValue[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.tag) {
            case 'B': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'e': 
            case 's': {
                sb.append(this.constantValue.getValue());
                break;
            }
            case 'Z': {
                sb.append(Integer.valueOf(1).equals(this.constantValue.getValue()));
                break;
            }
            case 'C': {
                sb.append((char)Integer.parseInt(this.constantValue.getValue().toString()));
                break;
            }
            case 'c': {
                sb.append("class ").append(this.type);
                break;
            }
            case '@': {
                sb.append(this.annotation);
                break;
            }
            case '[': {
                sb.append("[");
                for (ElementValue value : this.values) {
                    if (sb.length() >= 2) {
                        sb.append(", ");
                    }
                    sb.append(value);
                }
                sb.append("]");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ElementValue tag: " + this.tag);
            }
        }
        return sb.toString();
    }
}

