/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class InnerClass
implements DependencyHolder {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    private final String innerClassName;
    private final String outerClassName;
    private final String simpleName;
    private final int accessFlags;

    public InnerClass(DataInputStream is, ConstantPool constantPool) throws IOException {
        this.innerClassName = constantPool.getConstantClassName(is.readUnsignedShort());
        this.outerClassName = constantPool.getConstantClassName(is.readUnsignedShort());
        int simpleNameIndex = is.readUnsignedShort();
        this.simpleName = simpleNameIndex == 0 ? null : constantPool.getUtf8String(simpleNameIndex);
        this.accessFlags = is.readUnsignedShort();
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
    }

    public boolean isIndependentOfOuterClass(String thisClass) {
        return this.isStatic() && thisClass.equals(this.innerClassName);
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public String getInnerClassName() {
        return this.innerClassName;
    }

    public String getOuterClassName() {
        return this.outerClassName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.is(1)) {
            sb.append("public ");
        }
        if (this.is(4)) {
            sb.append("protected ");
        }
        if (this.is(2)) {
            sb.append("private ");
        }
        if (this.is(8)) {
            sb.append("static ");
        }
        if (this.is(16)) {
            sb.append("final ");
        }
        if (this.is(512)) {
            sb.append("interface ");
        }
        if (this.is(1024)) {
            sb.append("abstract ");
        }
        if (this.is(4096)) {
            sb.append("synthetic ");
        }
        if (this.is(8192)) {
            sb.append("@interface ");
        }
        if (this.is(16384)) {
            sb.append("enum ");
        }
        sb.append(this.innerClassName);
        if (this.outerClassName != null) {
            sb.append(" within ").append(this.outerClassName);
        }
        if (this.simpleName != null) {
            sb.append(" called ").append(this.simpleName);
        }
        return sb.toString();
    }

    private boolean is(int accessFlag) {
        return (this.accessFlags & accessFlag) == accessFlag;
    }
}

