/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.attribute.InnerClass;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class InnerClassesAttribute
extends AttributeInfo {
    private final InnerClass[] innerClasses;

    public InnerClassesAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        is.readInt();
        this.innerClasses = new InnerClass[is.readUnsignedShort()];
        for (int i = 0; i < this.innerClasses.length; ++i) {
            this.innerClasses[i] = new InnerClass(is, constantPool);
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (InnerClass innerClass : this.innerClasses) {
            innerClass.addDependentClassNames(classNames);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":\n");
        for (InnerClass innerClass : this.innerClasses) {
            sb.append("  ");
            sb.append(innerClass);
            sb.append(";\n");
        }
        return sb.toString();
    }
}

