/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class ModuleAttribute
extends AttributeInfo {
    public static final int ACC_OPEN = 32;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_MANDATED = 32768;
    public static final int ACC_TRANSITIVE = 32;
    public static final int ACC_STATIC_PHASE = 64;
    private final String moduleName;
    private final int moduleFlags;
    private final String moduleVersion;
    private final Require[] requires;
    private final Export[] exports;
    private final Open[] opens;
    private final Use[] uses;
    private final Provide[] provides;

    public ModuleAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        int i;
        this.skipLength(is);
        this.moduleName = constantPool.getModuleName(is.readUnsignedShort());
        this.moduleFlags = is.readUnsignedShort();
        int versionIndex = is.readUnsignedShort();
        this.moduleVersion = versionIndex == 0 ? null : constantPool.getUtf8String(versionIndex);
        this.requires = new Require[is.readUnsignedShort()];
        for (i = 0; i < this.requires.length; ++i) {
            this.requires[i] = new Require(is, constantPool);
        }
        this.exports = new Export[is.readUnsignedShort()];
        for (i = 0; i < this.exports.length; ++i) {
            this.exports[i] = new Export(is, constantPool);
        }
        this.opens = new Open[is.readUnsignedShort()];
        for (i = 0; i < this.opens.length; ++i) {
            this.opens[i] = new Open(is, constantPool);
        }
        this.uses = new Use[is.readUnsignedShort()];
        for (i = 0; i < this.uses.length; ++i) {
            this.uses[i] = new Use(is, constantPool);
        }
        this.provides = new Provide[is.readUnsignedShort()];
        for (i = 0; i < this.provides.length; ++i) {
            this.provides[i] = new Provide(is, constantPool);
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getModuleFlags() {
        return this.moduleFlags;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public Require[] getRequires() {
        return this.requires;
    }

    public Export[] getExports() {
        return this.exports;
    }

    public Open[] getOpens() {
        return this.opens;
    }

    public Use[] getUses() {
        return this.uses;
    }

    public Provide[] getProvides() {
        return this.provides;
    }

    public boolean isOpen() {
        return (this.moduleFlags & 0x20) != 0;
    }

    public boolean isSynthetic() {
        return (this.moduleFlags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.moduleFlags & 0x8000) != 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":\n");
        if (this.isMandated()) {
            sb.append("mandated ");
        }
        if (this.isSynthetic()) {
            sb.append("synthetic ");
        }
        if (this.isOpen()) {
            sb.append("open ");
        }
        sb.append("module ");
        sb.append(this.moduleName);
        if (this.moduleVersion != null) {
            sb.append("[").append(this.moduleVersion).append("]");
        }
        sb.append(" {\n");
        for (Require require : this.requires) {
            sb.append("  ");
            require.appendString(sb);
            sb.append(";\n");
        }
        for (Export export : this.exports) {
            sb.append("  ");
            export.appendString(sb);
            sb.append(";\n");
        }
        for (Open open : this.opens) {
            sb.append("  ");
            open.appendString(sb);
            sb.append(";\n");
        }
        for (Use use : this.uses) {
            sb.append("  ").append(use).append(";\n");
        }
        for (Provide provide : this.provides) {
            sb.append("  ");
            provide.appendString(sb);
            sb.append(";\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static class Provide {
        private final String className;
        private final String[] providesWith;

        private Provide(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.className = constantPool.getConstantClassName(is.readUnsignedShort());
            this.providesWith = new String[is.readUnsignedShort()];
            for (int i = 0; i < this.providesWith.length; ++i) {
                this.providesWith[i] = constantPool.getConstantClassName(is.readUnsignedShort());
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String[] getProvidesWith() {
            return this.providesWith;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendString(sb);
            return sb.toString();
        }

        void appendString(StringBuilder sb) {
            sb.append("provides ");
            sb.append(this.className);
            String separator = " with ";
            for (String with : this.providesWith) {
                sb.append(separator).append(with);
                separator = ", ";
            }
        }
    }

    public static class Use {
        private final String className;

        private Use(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.className = constantPool.getConstantClassName(is.readUnsignedShort());
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return "uses " + this.className;
        }
    }

    public static class Open {
        private final String packageName;
        private final int flags;
        private final String[] opensTo;

        private Open(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.packageName = constantPool.getPackageName(is.readUnsignedShort());
            this.flags = is.readUnsignedShort();
            this.opensTo = new String[is.readUnsignedShort()];
            for (int i = 0; i < this.opensTo.length; ++i) {
                this.opensTo[i] = constantPool.getModuleName(is.readUnsignedShort());
            }
        }

        public String getPackageName() {
            return this.packageName;
        }

        public int getFlags() {
            return this.flags;
        }

        public String[] getOpensTo() {
            return this.opensTo;
        }

        public boolean isUnqualified() {
            return this.opensTo.length == 0;
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendString(sb);
            return sb.toString();
        }

        void appendString(StringBuilder sb) {
            sb.append("opens ");
            if (this.isMandated()) {
                sb.append("mandated ");
            }
            if (this.isSynthetic()) {
                sb.append("synthetic ");
            }
            sb.append(this.packageName);
            String separator = " to ";
            for (String to : this.opensTo) {
                sb.append(separator).append(to);
                separator = ", ";
            }
        }
    }

    public static class Export {
        private final String packageName;
        private final int flags;
        private final String[] exportsTo;

        private Export(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.packageName = constantPool.getPackageName(is.readUnsignedShort());
            this.flags = is.readUnsignedShort();
            this.exportsTo = new String[is.readUnsignedShort()];
            for (int i = 0; i < this.exportsTo.length; ++i) {
                this.exportsTo[i] = constantPool.getModuleName(is.readUnsignedShort());
            }
        }

        public String getPackageName() {
            return this.packageName;
        }

        public int getFlags() {
            return this.flags;
        }

        public String[] getExportsTo() {
            return this.exportsTo;
        }

        public boolean isUnqualified() {
            return this.exportsTo.length == 0;
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendString(sb);
            return sb.toString();
        }

        void appendString(StringBuilder sb) {
            sb.append("exports ");
            if (this.isMandated()) {
                sb.append("mandated ");
            }
            if (this.isSynthetic()) {
                sb.append("synthetic ");
            }
            sb.append(this.packageName);
            String separator = " to ";
            for (String to : this.exportsTo) {
                sb.append(separator).append(to);
                separator = ", ";
            }
        }
    }

    public static class Require {
        private final String moduleName;
        private final int flags;
        private final String version;

        private Require(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.moduleName = constantPool.getModuleName(is.readUnsignedShort());
            this.flags = is.readUnsignedShort();
            int versionIndex = is.readUnsignedShort();
            this.version = versionIndex == 0 ? null : constantPool.getUtf8String(versionIndex);
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isTransitive() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isStaticPhase() {
            return (this.flags & 0x40) != 0;
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendString(sb);
            return sb.toString();
        }

        void appendString(StringBuilder sb) {
            sb.append("requires ");
            if (this.isMandated()) {
                sb.append("mandated ");
            }
            if (this.isSynthetic()) {
                sb.append("synthetic ");
            }
            if (this.isTransitive()) {
                sb.append("transitive ");
            }
            if (this.isStaticPhase()) {
                sb.append("static ");
            }
            sb.append(this.moduleName);
            if (this.version != null) {
                sb.append("[").append(this.version).append("]");
            }
        }
    }
}

