/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.constpool.FieldType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class RecordAttribute
extends AttributeInfo {
    private final RecordComponentInfo[] components;

    public RecordAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        this.skipLength(is);
        this.components = new RecordComponentInfo[is.readUnsignedShort()];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = new RecordComponentInfo(is, constantPool);
        }
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (RecordComponentInfo component : this.components) {
            component.addDependentClassNames(classNames);
        }
    }

    public RecordComponentInfo[] getComponents() {
        return this.components;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":\n");
        for (RecordComponentInfo component : this.components) {
            sb.append("  ");
            component.appendString(sb);
            sb.append(";\n");
        }
        return sb.toString();
    }

    public static class RecordComponentInfo {
        private final String name;
        private final FieldType type;
        private final AttributeInfo[] attributes;

        private RecordComponentInfo(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.name = constantPool.getUtf8String(is.readUnsignedShort());
            this.type = constantPool.getFieldType(is.readUnsignedShort());
            this.attributes = AttributeInfo.readAttributes(is, constantPool, AttributeInfo.AttributeContext.RECORD);
        }

        public String getName() {
            return this.name;
        }

        public FieldType getType() {
            return this.type;
        }

        public AttributeInfo[] getAttributes() {
            return this.attributes;
        }

        public void addDependentClassNames(Set<String> classNames) {
            this.type.addDependentClassNames(classNames);
            for (AttributeInfo attribute : this.attributes) {
                attribute.addDependentClassNames(classNames);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendString(sb);
            return sb.toString();
        }

        void appendString(StringBuilder sb) {
            sb.append(this.type.toString());
            sb.append(" ").append(this.name);
            for (AttributeInfo attribute : this.attributes) {
                sb.append("\n\t\t\t\t").append(attribute);
            }
        }
    }
}

