/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.Annotation;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class TypeAnnotation
implements DependencyHolder {
    private final byte targetType;
    private final TargetInfo targetInfo;
    private final TypePath targetPath;
    private final Annotation annotation;

    public TypeAnnotation(DataInputStream is, ConstantPool constantPool) throws IOException {
        this.targetType = is.readByte();
        this.targetInfo = TypeAnnotation.readTargetInfo(this.targetType, is, constantPool);
        this.targetPath = new TypePath(is, constantPool);
        this.annotation = new Annotation(is, constantPool);
    }

    private static TargetInfo readTargetInfo(int targetType, DataInputStream is, ConstantPool constantPool) throws IOException {
        switch (targetType) {
            case 0: 
            case 1: {
                return new TypeParameterTarget(is, constantPool);
            }
            case 16: {
                return new SuperTypeTarget(is, constantPool);
            }
            case 17: 
            case 18: {
                return new TypeParameterBoundTarget(is, constantPool);
            }
            case 19: 
            case 20: 
            case 21: {
                return new EmptyTarget(is, constantPool);
            }
            case 22: {
                return new FormalParameterTarget(is, constantPool);
            }
            case 23: {
                return new ThrowsTarget(is, constantPool);
            }
            case 64: 
            case 65: {
                return new LocalvarTarget(is, constantPool);
            }
            case 66: {
                return new CatchTarget(is, constantPool);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return new OffsetTarget(is, constantPool);
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return new TypeArgumentTarget(is, constantPool);
            }
        }
        throw new IllegalArgumentException("Unknown targetType: 0x" + Integer.toHexString(targetType).toUpperCase());
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.annotation.addDependentClassNames(classNames);
    }

    public String toString() {
        return this.annotation.toString();
    }

    static class TypePath {
        final Path[] path;

        TypePath(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.path = new Path[is.readUnsignedByte()];
            for (int i = 0; i < this.path.length; ++i) {
                this.path[i] = new Path(is, constantPool);
            }
        }
    }

    static class Path {
        final int typePathKind;
        final int typeArgumentIndex;

        Path(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.typePathKind = is.readUnsignedByte();
            this.typeArgumentIndex = is.readUnsignedByte();
        }
    }

    static class TypeArgumentTarget
    implements TargetInfo {
        final int offset;
        final int typeArgumentIndex;

        TypeArgumentTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.offset = is.readUnsignedShort();
            this.typeArgumentIndex = is.readUnsignedByte();
        }
    }

    static class OffsetTarget
    implements TargetInfo {
        final int offset;

        OffsetTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.offset = is.readUnsignedShort();
        }
    }

    static class CatchTarget
    implements TargetInfo {
        final int exceptionTableIndex;

        CatchTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.exceptionTableIndex = is.readUnsignedShort();
        }
    }

    static class LocalvarTarget
    implements TargetInfo {
        final Table[] table;

        LocalvarTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.table = new Table[is.readUnsignedShort()];
            for (int i = 0; i < this.table.length; ++i) {
                this.table[i] = new Table(is, constantPool);
            }
        }
    }

    static class Table {
        final int startPC;
        final int length;
        final int index;

        Table(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.startPC = is.readUnsignedShort();
            this.length = is.readUnsignedShort();
            this.index = is.readUnsignedShort();
        }
    }

    static class ThrowsTarget
    implements TargetInfo {
        final int throwsTypeIndex;

        ThrowsTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.throwsTypeIndex = is.readUnsignedShort();
        }
    }

    static class FormalParameterTarget
    implements TargetInfo {
        final int formalParameterIndex;

        FormalParameterTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.formalParameterIndex = is.readUnsignedByte();
        }
    }

    static class EmptyTarget
    implements TargetInfo {
        EmptyTarget(DataInputStream is, ConstantPool constantPool) {
        }
    }

    static class TypeParameterBoundTarget
    implements TargetInfo {
        final int typeParameterIndex;
        final int boundIndex;

        TypeParameterBoundTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.typeParameterIndex = is.readUnsignedByte();
            this.boundIndex = is.readUnsignedByte();
        }
    }

    static class SuperTypeTarget
    implements TargetInfo {
        static final int EXTENDS_INDEX = 65535;
        final int superTypeIndex;

        SuperTypeTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.superTypeIndex = is.readUnsignedShort();
        }
    }

    static class TypeParameterTarget
    implements TargetInfo {
        final int typeParameterIndex;

        TypeParameterTarget(DataInputStream is, ConstantPool constantPool) throws IOException {
            this.typeParameterIndex = is.readUnsignedByte();
        }
    }

    static interface TargetInfo {
    }
}

