/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.ConstantUtf8;
import java.util.BitSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConstantClass
extends ConstantPoolEntry {
    public static final int TAG = 7;
    private static final Pattern classArrayPattern = Pattern.compile("\\[+L(.*);");
    private final int nameIndex;

    public ConstantClass(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    @Override
    void recordReferences(BitSet references) {
        references.set(this.nameIndex);
    }

    @Override
    public String dump() {
        return this.dump(ConstantClass.index(this.nameIndex), this.getName());
    }

    public String getPhysicalName() {
        ConstantUtf8 name = (ConstantUtf8)this.getConstantPoolEntry(this.nameIndex);
        return name.getValue();
    }

    public String getName() {
        return this.getPhysicalName().replace('/', '.');
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        String classname;
        String name = this.getName();
        Matcher matcher = classArrayPattern.matcher(name);
        if (matcher.matches()) {
            classname = matcher.group(1);
        } else {
            if (name.startsWith("[")) {
                return;
            }
            classname = name;
        }
        classNames.add(classname);
    }
}

