/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.ConstantUtf8;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.constpool.MethodType;
import java.util.Set;

class ConstantNameAndType
extends ConstantPoolEntry {
    public static final int TAG = 12;
    private final int nameIndex;
    private final int descriptorIndex;

    public ConstantNameAndType(int nameIndex, int descriptorIndex) {
        this.nameIndex = nameIndex;
        this.descriptorIndex = descriptorIndex;
    }

    @Override
    String dump() {
        return this.dump(ConstantNameAndType.index(this.nameIndex) + ":" + ConstantNameAndType.index(this.descriptorIndex), this.getName() + ": " + this.getDescriptor());
    }

    public String getName() {
        ConstantUtf8 name = (ConstantUtf8)this.getConstantPoolEntry(this.nameIndex);
        return name.getValue();
    }

    public String getDescriptor() {
        ConstantUtf8 descriptor = (ConstantUtf8)this.getConstantPoolEntry(this.descriptorIndex);
        return descriptor.getValue();
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        ConstantUtf8 descriptor = (ConstantUtf8)this.getConstantPoolEntry(this.descriptorIndex);
        if (FieldType.isFieldDescriptor(descriptor.getValue())) {
            new FieldType(descriptor.getValue()).addDependentClassNames(classNames);
        } else if (MethodType.isMethodDescriptor(descriptor.getValue())) {
            new MethodType(descriptor.getValue()).addDependentClassNames(classNames);
        }
    }
}

