/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantClass;
import de.spricom.dessert.classfile.constpool.ConstantDouble;
import de.spricom.dessert.classfile.constpool.ConstantDynamic;
import de.spricom.dessert.classfile.constpool.ConstantFieldref;
import de.spricom.dessert.classfile.constpool.ConstantFloat;
import de.spricom.dessert.classfile.constpool.ConstantInteger;
import de.spricom.dessert.classfile.constpool.ConstantInterfaceMethodref;
import de.spricom.dessert.classfile.constpool.ConstantInvokeDynamic;
import de.spricom.dessert.classfile.constpool.ConstantLong;
import de.spricom.dessert.classfile.constpool.ConstantMethodHandle;
import de.spricom.dessert.classfile.constpool.ConstantMethodType;
import de.spricom.dessert.classfile.constpool.ConstantMethodref;
import de.spricom.dessert.classfile.constpool.ConstantModule;
import de.spricom.dessert.classfile.constpool.ConstantNameAndType;
import de.spricom.dessert.classfile.constpool.ConstantPackage;
import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.ConstantString;
import de.spricom.dessert.classfile.constpool.ConstantUtf8;
import de.spricom.dessert.classfile.constpool.ConstantValue;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.constpool.MethodType;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Set;

public final class ConstantPool
implements DependencyHolder {
    private final ConstantPoolEntry[] entries;
    private final BitSet referenced;

    public ConstantPool(DataInputStream is) throws IOException {
        int offset;
        this.entries = new ConstantPoolEntry[is.readUnsignedShort()];
        this.referenced = new BitSet(this.entries.length);
        for (int index = 1; index < this.entries.length; index += offset) {
            offset = 1;
            int tag = is.readUnsignedByte();
            switch (tag) {
                case 1: {
                    this.entries[index] = new ConstantUtf8(is.readUTF());
                    break;
                }
                case 3: {
                    this.entries[index] = new ConstantInteger(is.readInt());
                    break;
                }
                case 4: {
                    this.entries[index] = new ConstantFloat(is.readFloat());
                    break;
                }
                case 5: {
                    this.entries[index] = new ConstantLong(is.readLong());
                    offset = 2;
                    break;
                }
                case 6: {
                    this.entries[index] = new ConstantDouble(is.readDouble());
                    offset = 2;
                    break;
                }
                case 7: {
                    this.entries[index] = new ConstantClass(is.readUnsignedShort());
                    break;
                }
                case 8: {
                    this.entries[index] = new ConstantString(is.readUnsignedShort());
                    break;
                }
                case 9: {
                    this.entries[index] = new ConstantFieldref(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 10: {
                    this.entries[index] = new ConstantMethodref(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 11: {
                    this.entries[index] = new ConstantInterfaceMethodref(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 12: {
                    this.entries[index] = new ConstantNameAndType(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 15: {
                    this.entries[index] = new ConstantMethodHandle(is.readUnsignedByte(), is.readUnsignedShort());
                    break;
                }
                case 16: {
                    this.entries[index] = new ConstantMethodType(is.readUnsignedShort());
                    break;
                }
                case 17: {
                    this.entries[index] = new ConstantDynamic(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 18: {
                    this.entries[index] = new ConstantInvokeDynamic(is.readUnsignedShort(), is.readUnsignedShort());
                    break;
                }
                case 19: {
                    this.entries[index] = new ConstantModule(is.readUnsignedShort());
                    break;
                }
                case 20: {
                    this.entries[index] = new ConstantPackage(is.readUnsignedShort());
                    break;
                }
                default: {
                    throw new IOException("Unknown constant-pool tag: " + tag);
                }
            }
            this.entries[index].setConstantPool(this);
            this.entries[index].recordReferences(this.referenced);
        }
    }

    public String dumpConstantPool() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (ConstantPoolEntry entry : this.entries) {
            if (entry != null) {
                sb.append(String.format("%6s: %-18s %s%n", ConstantPoolEntry.index(index), entry.typeName() + this.referenced(index), entry.dump()));
            }
            ++index;
        }
        return sb.toString();
    }

    private String referenced(int index) {
        return this.referenced.get(index) ? "." : "";
    }

    <T> T getConstantPoolEntry(int index) {
        this.referenced.set(index);
        ConstantPoolEntry entry = this.entries[index];
        return (T)entry;
    }

    public String getUtf8String(int index) {
        ConstantUtf8 entry = (ConstantUtf8)this.getConstantPoolEntry(index);
        return entry.getValue();
    }

    public String getConstantClassName(int index) {
        ConstantClass clazz = (ConstantClass)this.getConstantPoolEntry(index);
        if (clazz == null) {
            return null;
        }
        return clazz.getName();
    }

    public FieldType getFieldType(int index) {
        ConstantUtf8 entry = (ConstantUtf8)this.getConstantPoolEntry(index);
        return new FieldType(entry.getValue());
    }

    public String getNameAndTypeName(int index) {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(index);
        return nameAndType.getName();
    }

    public MethodType getNameAndTypeMethodType(int index) {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.getConstantPoolEntry(index);
        return new MethodType(nameAndType.getDescriptor());
    }

    public <T> ConstantValue<T> getConstantValue(int index) {
        return (ConstantValue)this.getConstantPoolEntry(index);
    }

    public String getModuleName(int index) {
        ConstantModule entry = (ConstantModule)this.getConstantPoolEntry(index);
        return entry.getName();
    }

    public String getPackageName(int index) {
        ConstantPackage entry = (ConstantPackage)this.getConstantPoolEntry(index);
        return entry.getName();
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (int i = 1; i < this.entries.length; ++i) {
            ConstantPoolEntry entry = this.entries[i];
            if (entry == null) continue;
            entry.addDependentClassNames(classNames);
        }
    }
}

