/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.ConstantPoolEntry;
import de.spricom.dessert.classfile.constpool.ConstantValue;

class ConstantUtf8
extends ConstantPoolEntry
implements ConstantValue<String> {
    public static final int TAG = 1;
    private final String value;

    public ConstantUtf8(String value) {
        this.value = value;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                sb.append("\\n\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (Character.isISOControl((int)c) || !Character.isDefined((int)c)) {
                sb.append(String.format("\\u%04d", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

