/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.matching;

import de.spricom.dessert.matching.AnyShortNameMatcher;
import de.spricom.dessert.matching.ConstantShortNameMatcher;
import de.spricom.dessert.matching.RegexShortNameMatcher;
import de.spricom.dessert.matching.ShortNameMatcher;
import de.spricom.dessert.matching.WildcardShortNameMatcher;
import de.spricom.dessert.util.Assertions;

public class NamePattern
implements Comparable<NamePattern> {
    public static final NamePattern ANY_NAME = new NamePattern(NamePattern.createShortNameMatchers("..*")){

        @Override
        public boolean matches(String name) {
            return true;
        }
    };
    private final ShortNameMatcher[] shortNameMatchers;

    private NamePattern(ShortNameMatcher[] shortNameMatchers) {
        this.shortNameMatchers = shortNameMatchers;
    }

    public static NamePattern of(String pattern) {
        if ("..*".equals(pattern)) {
            return ANY_NAME;
        }
        NamePattern.validate(pattern);
        ShortNameMatcher[] shortNameMatchers = NamePattern.createShortNameMatchers(pattern);
        return new NamePattern(shortNameMatchers);
    }

    private static ShortNameMatcher[] createShortNameMatchers(String pattern) {
        if (pattern.startsWith("..")) {
            pattern = pattern.substring(1);
        }
        String[] parts = pattern.split("\\.");
        ShortNameMatcher[] shortNameMatchers = new ShortNameMatcher[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            shortNameMatchers[i] = NamePattern.createShortNameMatcher(shortNameMatchers, i, parts[i]);
        }
        return shortNameMatchers;
    }

    private static void validate(String pattern) {
        Assertions.notNull(pattern, "pattern");
        if (pattern.contains("...") || pattern.endsWith("..")) {
            throw new IllegalArgumentException("invalid pattern: " + pattern);
        }
    }

    private static ShortNameMatcher createShortNameMatcher(ShortNameMatcher[] shortNameMatchers, int i, String part) {
        if ("".equals(part)) {
            return new WildcardShortNameMatcher(shortNameMatchers, i);
        }
        if (part.equals("*")) {
            return new AnyShortNameMatcher(shortNameMatchers, i);
        }
        if (part.contains("*") || part.contains("|")) {
            return new RegexShortNameMatcher(shortNameMatchers, i, part);
        }
        return new ConstantShortNameMatcher(shortNameMatchers, i, part);
    }

    public boolean isAny() {
        return this == ANY_NAME;
    }

    public boolean isAllClasses() {
        return this.shortNameMatchers[this.shortNameMatchers.length - 1] instanceof AnyShortNameMatcher;
    }

    public boolean isMoreConcreteThan(NamePattern other) {
        if (this.isAny()) {
            return false;
        }
        if (other.isAny()) {
            return true;
        }
        return this.shortNameMatchers.length > other.shortNameMatchers.length;
    }

    public boolean matches(String name) {
        String[] parts = name.split("\\.");
        ShortNameMatcher matcher = this.matcher();
        for (int i = 0; i < parts.length; ++i) {
            if (!matcher.isMatchPossible()) {
                return false;
            }
            if (this.matchesAlternate(parts, i, matcher)) {
                return true;
            }
            matcher = matcher.match(parts[i]);
        }
        return matcher.matches();
    }

    public ShortNameMatcher matcher() {
        return this.shortNameMatchers[0];
    }

    private boolean matches(String[] parts, int index, ShortNameMatcher matcher) {
        for (int i = index; i < parts.length && matcher.isMatchPossible(); ++i) {
            if (this.matchesAlternate(parts, i, matcher)) {
                return true;
            }
            matcher = matcher.match(parts[i]);
        }
        return matcher.matches();
    }

    private boolean matchesAlternate(String[] parts, int index, ShortNameMatcher matcher) {
        if (!matcher.isWildcard()) {
            return false;
        }
        ShortNameMatcher alternate = matcher.next().match(parts[index]);
        return this.matches(parts, index + 1, alternate);
    }

    @Override
    public int compareTo(NamePattern o) {
        return Integer.valueOf(this.shortNameMatchers.length).compareTo(o.shortNameMatchers.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.shortNameMatchers[0].isWildcard()) {
            sb.append(".");
        } else {
            sb.append(this.shortNameMatchers[0]);
        }
        for (int i = 1; i < this.shortNameMatchers.length; ++i) {
            sb.append(".");
            if (this.shortNameMatchers[i].isWildcard()) continue;
            sb.append(this.shortNameMatchers[i]);
        }
        return sb.toString();
    }
}

