/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.modules.jpms;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.classfile.attribute.Attributes;
import de.spricom.dessert.classfile.attribute.ModuleAttribute;
import de.spricom.dessert.modules.core.AbstractModule;
import de.spricom.dessert.modules.jpms.JpmsModuleRequirement;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.Root;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.util.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class JpmsModule
extends AbstractModule {
    private final ModuleAttribute moduleAttribute;
    private final Root root;

    public JpmsModule(Root root, ClassFile moduleInfo) {
        this.root = root;
        this.moduleAttribute = this.getModuleAttribute(moduleInfo);
    }

    private ModuleAttribute getModuleAttribute(ClassFile moduleClassFile) {
        if (!moduleClassFile.isModule() || !moduleClassFile.getThisClass().endsWith("module-info")) {
            throw new IllegalArgumentException(moduleClassFile.getThisClass() + " is not a module-info.class!");
        }
        List<ModuleAttribute> moduleAttributes = Attributes.filter(moduleClassFile.getAttributes(), ModuleAttribute.class);
        if (moduleAttributes.size() != 1) {
            throw new IllegalArgumentException(moduleClassFile.getThisClass() + " does not contain a ModuleAttribute!");
        }
        return moduleAttributes.get(0);
    }

    @Override
    public String getName() {
        return this.moduleAttribute.getModuleName();
    }

    @Override
    public String getVersion() {
        return this.moduleAttribute.getModuleVersion();
    }

    public Root getRoot() {
        return this.root;
    }

    @Override
    public Root getImplementation() {
        return this.getRoot();
    }

    @Override
    public Slice getUnqualifiedExports() {
        return this.getExportsTo(null);
    }

    public Slice getExportsTo(String moduleName) {
        HashSet<String> exports = new HashSet<String>(this.moduleAttribute.getExports().length * 2);
        for (ModuleAttribute.Export export : this.moduleAttribute.getExports()) {
            if (export.isUnqualified()) {
                exports.add(export.getPackageName());
                continue;
            }
            if (moduleName == null) continue;
            for (String targetModule : export.getExportsTo()) {
                if (!targetModule.equals(moduleName)) continue;
                exports.add(export.getPackageName());
            }
        }
        return this.root.slice(new ExportedPredicate(exports));
    }

    public List<JpmsModuleRequirement> requirements() {
        ModuleAttribute.Require[] requires = this.moduleAttribute.getRequires();
        if (requires.length == 0) {
            return Collections.emptyList();
        }
        JpmsModuleRequirement[] requirements = new JpmsModuleRequirement[requires.length];
        for (int i = 0; i < requires.length; ++i) {
            requirements[i] = new JpmsModuleRequirement(requires[i]);
        }
        return Arrays.asList(requirements);
    }

    static class ExportedPredicate
    implements Predicate<Clazz> {
        final Set<String> exports;

        public ExportedPredicate(Set<String> exports) {
            this.exports = exports;
        }

        @Override
        public boolean test(Clazz clazz) {
            return this.exports.contains(clazz.getPackageName());
        }
    }
}

