/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassResolverCache;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.ClassVisitor;
import de.spricom.dessert.resolve.DirectoryRoot;
import de.spricom.dessert.resolve.JarRoot;
import de.spricom.dessert.resolve.JrtModuleRoot;
import de.spricom.dessert.resolve.ReflectiveJrtFileSystem;
import de.spricom.dessert.resolve.ResolveException;
import de.spricom.dessert.resolve.TraversalRoot;
import de.spricom.dessert.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassResolver
implements TraversalRoot {
    private static final Logger log = Logger.getLogger(ClassResolver.class.getName());
    private final List<ClassRoot> path = new ArrayList<ClassRoot>(60);
    private final ClassResolverCache cache = new ClassResolverCache();
    private boolean ignoreManifest;
    private boolean frozen;

    public static ClassResolver of(String path) {
        ClassResolver r = new ClassResolver();
        r.add(path);
        return r;
    }

    public static ClassResolver ofClassPath() {
        ClassResolver r = new ClassResolver();
        r.addClassPath();
        return r;
    }

    public static ClassResolver ofClassPathAndJavaRuntime() {
        long ts = System.nanoTime();
        ClassResolver r = new ClassResolver();
        r.addClassPath();
        r.addBootClassPath();
        r.addJavaRuntimeModules();
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Needed %.1f ms to scan classes form java.class.path and runtime.", (double)(System.nanoTime() - ts) / 1000000.0));
        }
        return r;
    }

    public static ClassResolver ofClassPathWithoutJars() {
        ClassResolver r = new ClassResolver();
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (entry.endsWith(".jar")) continue;
            r.addFile(entry);
        }
        return r;
    }

    public static ClassResolver ofClassPathIgnoringManifests() {
        ClassResolver r = new ClassResolver();
        r.setIgnoreManifest(true);
        r.addClassPath();
        return r;
    }

    @Deprecated
    public static ClassResolver ofClassPathAndBootClassPath() {
        ClassResolver r = new ClassResolver();
        r.addClassPath();
        r.addBootClassPath();
        return r;
    }

    public void addClassPath() {
        this.add(System.getProperty("java.class.path"));
    }

    public void addBootClassPath() {
        String path = System.getProperty("sun.boot.class.path");
        if (path != null) {
            this.add(path);
        }
    }

    public void addJavaRuntimeModules() {
        if (!ClassResolver.isJrtFileSystemAvailable()) {
            return;
        }
        try {
            ReflectiveJrtFileSystem fs = new ReflectiveJrtFileSystem();
            for (String module : fs.listModules()) {
                this.addRoot(new JrtModuleRoot(module, fs));
            }
        }
        catch (IOException ex) {
            throw new ResolveException("Unable to read java runtime modules: " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof IOException) {
                throw new ResolveException("Unable to read java runtime modules: " + ex.getTargetException().getMessage(), ex.getTargetException());
            }
            throw new ResolveException("Unable to read java runtime modules.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ResolveException("Cannot access NIO classes.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ResolveException("Cannot access NIO classes.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ResolveException("Cannot access NIO classes.", ex);
        }
        catch (URISyntaxException ex) {
            throw new ResolveException("Cannot convert jrt-URI.", ex);
        }
    }

    public static boolean isJrtFileSystemAvailable() {
        URL resource = String.class.getResource("String.class");
        return resource != null && "jrt".equalsIgnoreCase(resource.getProtocol());
    }

    public void add(String path) {
        for (String entry : path.split(File.pathSeparator)) {
            this.addFile(entry);
        }
    }

    private void addFile(String filename) {
        this.add(new File(filename));
    }

    public void add(File file) {
        try {
            if (!file.exists()) {
                log.warning("Does not exist: " + file.getAbsolutePath());
            } else if (this.getRoot(file) != null) {
                log.warning("Already on path: " + file.getAbsolutePath());
            } else if (file.isDirectory()) {
                this.addRoot(new DirectoryRoot(file));
            } else if (file.isFile() && file.getName().endsWith(".jar")) {
                JarRoot root = new JarRoot(file);
                this.addRoot(root);
                if (!this.ignoreManifest) {
                    this.addManifestClassPath(root);
                }
            } else {
                log.warning("Don't know how to process: " + file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            throw new ResolveException("Unable to resolve " + file.getAbsolutePath() + ": " + ex.getMessage(), ex);
        }
    }

    public void addRoot(ClassRoot root) throws IOException {
        if (this.frozen) {
            throw new IllegalStateException("Cannot add root to a frozen ClassResolver.");
        }
        this.path.add(root);
        long ts = System.nanoTime();
        root.scan(this.cache);
        if (log.isLoggable(Level.FINER)) {
            log.fine(String.format("Needed %.1f ms to scan classes form %s.", (double)(System.nanoTime() - ts) / 1000000.0, root.getURI()));
        }
    }

    public void addManifestClassPath(JarRoot jarRoot) throws IOException {
        Manifest manifest = jarRoot.getManifest();
        if (manifest == null) {
            return;
        }
        String classpath = manifest.getMainAttributes().getValue("Class-Path");
        if (classpath == null) {
            return;
        }
        URL context = jarRoot.getRootFile().toURI().toURL();
        for (String relativeUrl : classpath.split("\\s+")) {
            try {
                File file = new File(new URL(context, relativeUrl).toURI().getPath());
                if (file.exists()) {
                    this.add(file);
                    continue;
                }
                log.info("Does not exist: " + file.getAbsolutePath() + " (referenced by Manifest of " + context + ")");
            }
            catch (URISyntaxException ex) {
                log.warning("Unable to parse relative path " + relativeUrl + " within Manifest of " + context + ": " + ex.getMessage());
            }
        }
    }

    public boolean isIgnoreManifest() {
        return this.ignoreManifest;
    }

    public void setIgnoreManifest(boolean ignoreManifest) {
        this.ignoreManifest = ignoreManifest;
    }

    public void freeze() {
        this.frozen = true;
    }

    public ClassRoot getRoot(File file) {
        for (ClassRoot root : this.path) {
            if (!root.getRootFile().equals(file)) continue;
            return root;
        }
        return null;
    }

    public ClassPackage getPackage(String packageName) {
        return this.cache.getPackage(packageName);
    }

    public ClassPackage getPackage(File root, String packageName) {
        ClassPackage pckg = this.getPackage(packageName);
        if (pckg == null) {
            return null;
        }
        URI rootUri = root.toURI();
        if (rootUri.equals(pckg.getRoot().getURI())) {
            return pckg;
        }
        if (pckg.getAlternatives() != null) {
            for (ClassPackage alt : pckg.getAlternatives()) {
                if (!rootUri.equals(alt.getRoot().getURI())) continue;
                return alt;
            }
        }
        return null;
    }

    public ClassEntry getClassEntry(String classname) {
        return this.cache.getClassEntry(classname);
    }

    public ClassEntry getClassEntry(File root, String classname) {
        ClassEntry ce = this.getClassEntry(classname);
        if (ce == null) {
            return null;
        }
        URI rootUri = root.toURI();
        if (rootUri.equals(ce.getPackage().getRoot().getURI())) {
            return ce;
        }
        if (ce.getAlternatives() != null) {
            for (ClassEntry alt : ce.getAlternatives()) {
                if (!rootUri.equals(alt.getPackage().getRoot().getURI())) continue;
                return alt;
            }
        }
        return null;
    }

    @Override
    public void traverse(NamePattern pattern, ClassVisitor visitor) {
        for (ClassRoot classRoot : this.path) {
            classRoot.traverse(pattern, visitor);
        }
    }

    public List<ClassRoot> getPath() {
        return this.path;
    }

    public Set<File> getRootFiles() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return t != null;
            }
        });
    }

    public Set<File> getRootJars() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return t != null && !t.isDirectory();
            }
        });
    }

    public Set<File> getRootDirs() {
        return this.getRootFiles(new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return t != null && t.isDirectory();
            }
        });
    }

    public Set<File> getRootFiles(Predicate<File> predicate) {
        HashSet<File> files = new HashSet<File>(this.path.size());
        for (ClassRoot cr : this.path) {
            if (!predicate.test(cr.getRootFile())) continue;
            files.add(cr.getRootFile());
        }
        return files;
    }

    public Map<String, List<ClassEntry>> getDuplicates() {
        return this.cache.getDuplicates();
    }

    public int getPackageCount() {
        return this.cache.getPackageCount();
    }

    public int getClassCount() {
        return this.cache.getClassCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (File root : this.getRootFiles()) {
            if (sb.length() == 0) {
                sb.append("classpath ");
            } else {
                sb.append(File.pathSeparator);
            }
            sb.append(root.getAbsolutePath());
        }
        return sb.toString();
    }
}

