/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassVisitor;
import de.spricom.dessert.resolve.TraversalRoot;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.jar.Manifest;

public abstract class ClassRoot
extends ClassPackage
implements TraversalRoot {
    private final File rootFile;

    protected ClassRoot(File rootFile) {
        this.rootFile = rootFile;
    }

    protected abstract void scan(ClassCollector var1) throws IOException;

    @Override
    public final void traverse(NamePattern pattern, ClassVisitor visitor) {
        this.traverse(pattern.matcher(), visitor);
    }

    @Override
    public final ClassRoot getRoot() {
        return this;
    }

    @Override
    public final File getRootFile() {
        return this.rootFile;
    }

    public abstract URL getResource(String var1);

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read from " + url + ": " + ex, ex);
        }
    }

    public Manifest getManifest() throws IOException {
        InputStream inputStream = this.getResourceAsStream("META-INF/MANIFEST.MF");
        if (inputStream == null) {
            return null;
        }
        return new Manifest(inputStream);
    }

    public URI getURI() {
        return this.getRootFile().toURI();
    }

    @Override
    public String toString() {
        return "root " + this.getURI();
    }
}

