/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DirectoryClassEntry
extends ClassEntry {
    private static final Logger log = Logger.getLogger(DirectoryClassEntry.class.getName());
    private final File classFile;

    DirectoryClassEntry(ClassPackage pckg, File classFile) {
        super(pckg.getClassName(DirectoryClassEntry.simpleName(classFile)), pckg);
        this.classFile = classFile;
    }

    private static String simpleName(File classFile) {
        return classFile.getName().substring(0, classFile.getName().length() - ".class".length());
    }

    @Override
    public ClassFile resolveClassFile() {
        FileInputStream is = null;
        try {
            ClassFile cf;
            is = new FileInputStream(this.classFile);
            ClassFile classFile = cf = new ClassFile(is);
            return classFile;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read " + this.classFile.getAbsolutePath(), ex);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "Cannot close stream after reading " + this.classFile.getAbsolutePath(), ex);
                }
            }
        }
    }

    @Override
    public URI getURI() {
        return this.classFile.toURI();
    }
}

