/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassPackage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JrtModuleClassEntry
extends ClassEntry {
    private static final Logger log = Logger.getLogger(JrtModuleClassEntry.class.getName());
    private final URI uri;

    JrtModuleClassEntry(ClassPackage pckg, String simpleName, URI uri) {
        super(pckg.getClassName(simpleName), pckg);
        this.uri = uri;
    }

    @Override
    public ClassFile resolveClassFile() {
        InputStream is = null;
        try {
            ClassFile cf;
            URL url = this.uri.toURL();
            is = url.openStream();
            ClassFile classFile = cf = new ClassFile(is);
            return classFile;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read " + this.uri, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "Cannot close stream after reading " + this.uri, ex);
                }
            }
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }
}

