/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.TraversalRoot;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.DeferredSlice;
import de.spricom.dessert.slicing.DerivedSlice;
import de.spricom.dessert.slicing.NamePatternClazzResolver;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.util.Predicate;
import java.util.Set;

public abstract class AbstractRootSlice
extends AbstractSlice {
    private final TraversalRoot traversalRoot;
    private ConcreteSlice concreteSlice;

    AbstractRootSlice(TraversalRoot traversalRoot) {
        this.traversalRoot = traversalRoot;
    }

    public Slice packageOf(Class<?> clazz) {
        return this.packageOf(clazz.getPackage());
    }

    public Slice packageOf(Package pkg) {
        return this.packageOf(pkg.getName());
    }

    public Slice packageOf(String packageName) {
        return this.slice(packageName + ".*");
    }

    public Slice packageTreeOf(Class<?> clazz) {
        return this.packageTreeOf(clazz.getPackage());
    }

    public Slice packageTreeOf(Package pkg) {
        return this.packageTreeOf(pkg.getName());
    }

    public Slice packageTreeOf(String packageName) {
        return this.slice(packageName + "..*");
    }

    @Override
    public Slice slice(String pattern) {
        if (this.concreteSlice != null) {
            Slice slice = this.concreteSlice.slice(pattern);
            if (slice.getClazzes().isEmpty()) {
                if (this.isConcrete()) {
                    return Slices.EMPTY_SLICE;
                }
                return new DerivedSlice(NamePattern.of(pattern));
            }
            return slice;
        }
        NamePattern namePattern = NamePattern.of(pattern);
        return new DeferredSlice(new DerivedSlice(namePattern), this.resolver(namePattern), this.isConcrete());
    }

    @Override
    public Slice slice(Predicate<Clazz> predicate) {
        if (this.concreteSlice != null) {
            return this.concreteSlice.slice((Predicate)predicate);
        }
        return new DeferredSlice(new DerivedSlice(predicate), this.resolver(NamePattern.ANY_NAME), this.isConcrete());
    }

    @Override
    public boolean contains(Clazz clazz) {
        if (this.concreteSlice != null) {
            return this.concreteSlice.contains(clazz);
        }
        NamePattern name = NamePattern.of(clazz.getName());
        return this.resolver(name).getClazzes().contains(clazz);
    }

    @Override
    public Set<Clazz> getClazzes() {
        return this.getConcreteSlice().getClazzes();
    }

    private ConcreteSlice getConcreteSlice() {
        if (this.concreteSlice == null) {
            this.concreteSlice = new ConcreteSlice(this.resolver().getClazzes());
        }
        return this.concreteSlice;
    }

    private NamePatternClazzResolver resolver() {
        return this.resolver(NamePattern.ANY_NAME);
    }

    private NamePatternClazzResolver resolver(NamePattern namePattern) {
        return new NamePatternClazzResolver(this.getClasspath(), namePattern, this.traversalRoot);
    }

    abstract Classpath getClasspath();

    abstract boolean isConcrete();
}

