/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassResolver;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.ResolveException;
import de.spricom.dessert.slicing.AbstractRootSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.Root;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.util.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Classpath
extends AbstractRootSlice {
    private static final Logger log = Logger.getLogger(Classpath.class.getName());
    private static ClassResolver defaultResolver;
    private final ClassResolver resolver;
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();

    public Classpath() {
        this(Classpath.getDefaultResolver());
    }

    public Classpath(ClassResolver resolver) {
        super(resolver);
        this.resolver = resolver;
        resolver.freeze();
    }

    private static ClassResolver getDefaultResolver() {
        if (defaultResolver == null) {
            defaultResolver = ClassResolver.ofClassPathAndJavaRuntime();
        }
        return defaultResolver;
    }

    Clazz asClazz(ClassEntry ce) {
        Clazz clazz = this.classes.get(ce.getClassname());
        if (clazz == null) {
            clazz = new Clazz(this, ce);
            this.classes.put(ce.getClassname(), clazz);
            return clazz;
        }
        Clazz alt = clazz.getAlternative(ce);
        assert (alt != null) : "alternative for " + ce.getURI() + " is null";
        return alt;
    }

    public Clazz asClazz(String classname) {
        Clazz clazz = this.classes.get(classname);
        if (clazz == null) {
            clazz = this.resolveClazz(classname);
            if (clazz == null) {
                clazz = this.loadClass(classname);
            }
            if (clazz == null) {
                clazz = this.undefined(classname);
            }
            this.classes.put(classname, clazz);
        }
        return clazz;
    }

    public Clazz asClazz(Class<?> classImpl) {
        URI uri = ClassUtils.getURI(classImpl);
        String classname = classImpl.getName();
        Clazz clazz = this.classes.get(classname);
        if (clazz == null && (clazz = this.resolveClazz(classname)) != null) {
            this.classes.put(classname, clazz);
        }
        if (clazz != null) {
            for (Clazz alternative : clazz.getAlternatives()) {
                if (!uri.equals(alternative.getURI())) continue;
                return alternative;
            }
        }
        Clazz newClazz = this.createClazz(classImpl);
        if (clazz == null) {
            this.classes.put(classname, newClazz);
        } else {
            clazz.getAlternatives().add(newClazz);
        }
        return newClazz;
    }

    private Clazz resolveClazz(String classname) {
        ClassEntry resolverEntry = this.resolver.getClassEntry(classname);
        if (resolverEntry == null) {
            return null;
        }
        return new Clazz(this, resolverEntry);
    }

    private Clazz createClazz(Class<?> clazz) {
        try {
            return new Clazz(this, clazz);
        }
        catch (IOException ex) {
            throw new ResolveException("Cannot analyze " + clazz, ex);
        }
    }

    private Clazz loadClass(String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            return new Clazz(this, clazz);
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.FINE, "Cannot find " + classname, ex);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Cannot analyze " + classname, ex);
        }
        return null;
    }

    private Clazz undefined(String classname) {
        return new Clazz(this, classname);
    }

    public ConcreteSlice duplicates() {
        HashSet<Clazz> sliceEntries = new HashSet<Clazz>();
        for (List<ClassEntry> alternatives : this.resolver.getDuplicates().values()) {
            for (ClassEntry alternative : alternatives) {
                sliceEntries.add(this.asClazz(alternative));
            }
        }
        return new ConcreteSlice(sliceEntries);
    }

    public Root rootOf(Class<?> clazz) {
        return this.rootOfClass(clazz.getName());
    }

    public Root rootOfClass(String classname) {
        ClassEntry cf = this.resolver.getClassEntry(classname);
        if (cf == null) {
            throw new IllegalArgumentException(classname + " not found within this classpath.");
        }
        return this.rootOf(cf.getPackage().getRoot());
    }

    public Root rootOf(File rootFile) {
        return this.rootOf(this.getClassRoot(rootFile));
    }

    Root rootOf(ClassRoot root) {
        return new Root(root, this);
    }

    private ClassRoot getClassRoot(File rootFile) {
        if (rootFile == null) {
            throw new NullPointerException("rootFile must not be null");
        }
        ClassRoot root = this.resolver.getRoot(rootFile);
        if (root == null) {
            throw new IllegalArgumentException(rootFile + " has not been registered with this context.");
        }
        return root;
    }

    public Slice sliceOf(Class<?> ... classes) {
        if (classes.length == 0) {
            return Slices.EMPTY_SLICE;
        }
        if (classes.length == 1) {
            return this.asClazz(classes[0]);
        }
        HashSet<Clazz> clazzes = new HashSet<Clazz>();
        for (Class<?> clazz : classes) {
            clazzes.add(this.asClazz(clazz));
        }
        return new ConcreteSlice(clazzes);
    }

    @Override
    Classpath getClasspath() {
        return this;
    }

    @Override
    boolean isConcrete() {
        return false;
    }
}

