/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ResolveException;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Concrete;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.Root;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.util.ClassUtils;
import de.spricom.dessert.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public final class Clazz
extends AbstractSlice
implements Comparable<Clazz>,
Concrete {
    private static final Logger log = Logger.getLogger(Clazz.class.getName());
    public static final Clazz UNDEFINED = new Clazz();
    private final Classpath classpath;
    private final String className;
    private final ClassFile classFile;
    private final ClassEntry classEntry;
    private Class<?> classImpl;
    private URI uri;
    private Clazz superclass;
    private List<Clazz> implementedInterfaces;
    private ConcreteSlice dependencies;
    private List<Clazz> alternatives;
    private Clazz host;
    private Slice nest;

    private Clazz() {
        this.classpath = null;
        this.className = "undefined";
        this.classFile = null;
        this.classEntry = null;
        this.superclass = this;
        this.implementedInterfaces = Collections.emptyList();
        this.dependencies = ConcreteSlice.EMPTY_SLICE;
        this.alternatives = Collections.emptyList();
    }

    Clazz(Classpath classpath, ClassEntry classEntry) {
        assert (classpath != null) : "context == null";
        assert (classEntry != null) : "classEntry == null";
        this.classpath = classpath;
        this.classFile = classEntry.getClassfile();
        this.className = this.classFile.getThisClass();
        this.classEntry = classEntry;
        if (classEntry.getAlternatives() != null) {
            for (ClassEntry alternative : classEntry.getAlternatives()) {
                if (classEntry == alternative) continue;
                new Clazz(this, alternative);
            }
        }
    }

    Clazz(Clazz alternative, ClassEntry classEntry) {
        assert (alternative != null) : "alternative == null";
        assert (classEntry != null) : "classEntry == null";
        this.classpath = alternative.classpath;
        this.classEntry = classEntry;
        this.classFile = classEntry.getClassfile();
        this.className = this.classFile.getThisClass();
        if (alternative.alternatives == null) {
            alternative.alternatives = new LinkedList<Clazz>();
            alternative.alternatives.add(alternative);
        }
        this.alternatives = alternative.alternatives;
        this.alternatives.add(this);
    }

    Clazz(Classpath classpath, Class<?> classImpl) throws IOException {
        assert (classpath != null) : "context == null";
        assert (classImpl != null) : "clazz == null";
        this.classpath = classpath;
        this.classImpl = classImpl;
        this.classEntry = null;
        this.classFile = new ClassFile(classImpl);
        this.className = this.classFile.getThisClass();
    }

    Clazz(Classpath classpath, String className) {
        assert (classpath != null) : "context == null";
        assert (className != null) : "className == null";
        this.classpath = classpath;
        this.classEntry = null;
        this.classFile = null;
        this.className = className;
        this.superclass = UNDEFINED;
        this.implementedInterfaces = Collections.emptyList();
        this.dependencies = ConcreteSlice.EMPTY_SLICE;
        this.alternatives = Collections.emptyList();
    }

    @Deprecated
    public File getRootFile() {
        Root root = this.getRoot();
        return root == null ? null : root.getRootFile();
    }

    public Root getRoot() {
        if (this.classEntry != null) {
            return this.classpath.rootOf(this.classEntry.getPackage().getRoot());
        }
        if (this.classImpl != null) {
            return this.classpath.rootOf(this.classImpl);
        }
        return null;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public String getName() {
        return this.className;
    }

    public String getPackageName() {
        if (this.classEntry != null) {
            return this.classEntry.getPackage().getPackageName();
        }
        if (this.classImpl != null) {
            return this.classImpl.getPackage().getName();
        }
        int index = this.className.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.className.substring(0, index);
    }

    public String getSimpleName() {
        if (this.classFile != null) {
            return this.classFile.getSimpleName();
        }
        if (this.classImpl != null) {
            return this.classImpl.getSimpleName();
        }
        int dollarIndex = this.className.lastIndexOf(36);
        if (dollarIndex > 0) {
            String name = this.className.substring(dollarIndex + 1);
            if (name.matches("\\d+")) {
                return "";
            }
            return name;
        }
        return this.getShortName();
    }

    public String getShortName() {
        if (this.classEntry != null) {
            return this.classEntry.getShortName();
        }
        String packageName = this.getPackageName();
        if (packageName.isEmpty()) {
            return this.className;
        }
        return this.className.substring(packageName.length() + 1);
    }

    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.classEntry != null) {
            this.uri = this.classEntry.getURI();
            return this.uri;
        }
        if (this.classImpl != null) {
            this.uri = ClassUtils.getURI(this.classImpl);
        } else {
            String unknown = "dessert:unknown:" + this.className;
            try {
                this.uri = new URI(unknown);
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("Cannot convert '" + unknown + "' to URI", ex);
            }
        }
        return this.uri;
    }

    @Override
    public Slice slice(Predicate<Clazz> predicate) {
        return predicate.test(this) ? this : Slices.EMPTY_SLICE;
    }

    @Override
    public boolean contains(Clazz clazz) {
        return this.equals(clazz);
    }

    @Override
    public Set<Clazz> getClazzes() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clazz other = (Clazz)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.getURI().equals(other.getURI());
    }

    @Override
    public int compareTo(Clazz o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "clazz " + this.className;
    }

    public boolean isUnknown() {
        return this.classFile == null;
    }

    public Class<?> getClassImpl() {
        if (this.classImpl == null && !this.isUnknown()) {
            try {
                this.classImpl = Class.forName(this.className);
                if (!this.getURI().equals(ClassUtils.getURI(this.classImpl))) {
                    log.warning("Loaded class " + ClassUtils.getURI(this.classImpl) + " for entry " + this.getURI() + "!");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ResolveException("Unable to load " + this.className, ex);
            }
        }
        return this.classImpl;
    }

    public Clazz getSuperclass() {
        if (this.superclass == null && this.classFile != null) {
            this.superclass = this.classpath.asClazz(this.classFile.getSuperClass());
        }
        return this.superclass;
    }

    public List<Clazz> getImplementedInterfaces() {
        if (this.implementedInterfaces == null && this.classFile != null) {
            this.implementedInterfaces = new ArrayList<Clazz>(this.classFile.getInterfaces().length);
            for (String in : this.classEntry.getClassfile().getInterfaces()) {
                this.implementedInterfaces.add(this.classpath.asClazz(in));
            }
        }
        return this.implementedInterfaces;
    }

    public Clazz getHost() {
        if (this.host == null) {
            if (this.classFile != null) {
                String nestHostName = this.classFile.getNestHost();
                this.host = nestHostName == null || nestHostName.equals(this.className) ? this : this.classpath.asClazz(nestHostName);
            } else if (this.classImpl != null) {
                Class<?> enclosingClass = this.classImpl;
                while (enclosingClass.getEnclosingClass() != null) {
                    enclosingClass = enclosingClass.getEnclosingClass();
                }
                this.host = this.classpath.asClazz(enclosingClass);
            } else if (this.className.indexOf(36) >= 0) {
                String hostClassname = this.className.substring(0, this.className.indexOf(36));
                this.host = this.classpath.asClazz(hostClassname);
            } else {
                this.host = this;
            }
        }
        return this.host;
    }

    public Slice getNest() {
        if (this.nest == null) {
            ClassFile hostClassFile = this.getHost().classFile;
            if (hostClassFile == null) {
                this.nest = this;
            } else {
                List<String> nestMembers = hostClassFile.getNestMembers();
                if (nestMembers.isEmpty()) {
                    this.nest = this;
                } else {
                    TreeSet<Clazz> nestClazzes = new TreeSet<Clazz>();
                    nestClazzes.add(this.getHost());
                    for (String nestMember : nestMembers) {
                        Clazz nestClazz = this.classpath.asClazz(nestMember);
                        nestClazzes.add(nestClazz);
                        if (hostClassFile.getMajorVersion() >= 55) continue;
                        this.addNextMembersRecursive(nestClazzes, nestClazz);
                    }
                    this.nest = new ConcreteSlice(nestClazzes);
                }
            }
        }
        return this.nest;
    }

    private void addNextMembersRecursive(Set<Clazz> nestClazzes, Clazz outerClazz) {
        if (outerClazz.classFile == null) {
            return;
        }
        List<String> nestMembers = outerClazz.classFile.getNestMembers();
        if (nestMembers.isEmpty()) {
            return;
        }
        for (String nestMember : nestMembers) {
            Clazz nestedClazz = this.classpath.asClazz(nestMember);
            if (!nestClazzes.add(nestedClazz)) continue;
            this.addNextMembersRecursive(nestClazzes, nestedClazz);
        }
    }

    @Override
    public ConcreteSlice getDependencies() {
        if (this.dependencies == null && this.classFile != null) {
            HashSet<Clazz> deps = new HashSet<Clazz>(this.classFile.getDependentClasses().size());
            for (String cn : this.classFile.getDependentClasses()) {
                deps.add(this.classpath.asClazz(cn));
            }
            this.dependencies = new ConcreteSlice(deps);
        }
        return this.dependencies;
    }

    public List<Clazz> getAlternatives() {
        if (this.alternatives == null) {
            return Collections.singletonList(this);
        }
        return this.alternatives;
    }

    Clazz getAlternative(ClassEntry ce) {
        if (this.matches(ce)) {
            return this;
        }
        if (this.alternatives != null) {
            for (Clazz alt : this.alternatives) {
                if (!alt.matches(ce)) continue;
                return alt;
            }
        }
        return null;
    }

    private boolean matches(ClassEntry ce) {
        if (this.classEntry != null) {
            return this.classEntry == ce;
        }
        return this.getURI().equals(ce.getURI());
    }

    @Deprecated
    public String getMinVersion() {
        String uri = this.getURI().toString();
        int i = uri.toUpperCase().indexOf("/META-INF/VERSIONS/");
        int l = this.className.length() + "/.class".length();
        if (i > 0 && i + l < uri.length()) {
            return uri.substring(i + "/META-INF/VERSIONS/".length(), uri.length() - l);
        }
        return null;
    }

    public Integer getVersion() {
        return this.classEntry == null ? null : this.classEntry.getVersion();
    }
}

