/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.NamePatternClazzResolver;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.util.Predicate;
import java.util.HashSet;
import java.util.Set;

class DeferredSlice
extends AbstractSlice {
    private final Slice derivedSlice;
    private final NamePatternClazzResolver resolver;
    private final boolean resolvesConcrete;
    private final Set<Clazz> cache = new HashSet<Clazz>();
    private ConcreteSlice concreteSlice;

    DeferredSlice(Slice derivedSlice, NamePatternClazzResolver resolver, boolean resolvesConcrete) {
        this.derivedSlice = derivedSlice;
        this.resolver = resolver;
        this.resolvesConcrete = resolvesConcrete;
    }

    @Override
    public Slice slice(String pattern) {
        if (this.isConcrete()) {
            return this.concreteSlice.slice(pattern);
        }
        return new DeferredSlice(this.derivedSlice.slice(pattern), this.resolver.filtered(NamePattern.of(pattern)), this.resolvesConcrete);
    }

    @Override
    public Slice slice(Predicate<Clazz> predicate) {
        if (this.isConcrete()) {
            return this.concreteSlice.slice((Predicate)predicate);
        }
        return new DeferredSlice(this.derivedSlice.slice(predicate), this.resolver, this.resolvesConcrete);
    }

    @Override
    public boolean contains(Clazz clazz) {
        if (this.isConcrete()) {
            return this.concreteSlice.contains(clazz);
        }
        if (this.cache.contains(clazz)) {
            return true;
        }
        if (!this.derivedSlice.contains(clazz)) {
            return false;
        }
        if (!this.resolvesConcrete) {
            return true;
        }
        NamePatternClazzResolver singleClassResolver = this.resolver.filtered(NamePattern.of(clazz.getName()));
        boolean member = singleClassResolver.getClazzes().contains(clazz);
        if (member) {
            this.cache.add(clazz);
        }
        return member;
    }

    private boolean isConcrete() {
        return this.concreteSlice != null && (!this.concreteSlice.getClazzes().isEmpty() || this.resolvesConcrete);
    }

    @Override
    public Set<Clazz> getClazzes() {
        if (this.concreteSlice == null) {
            ConcreteSlice cs = new ConcreteSlice(this.resolver.getClazzes());
            this.concreteSlice = cs.slice((Predicate)new Predicate<Clazz>(){

                @Override
                public boolean test(Clazz clazz) {
                    return DeferredSlice.this.derivedSlice.contains(clazz);
                }
            });
        }
        this.cache.clear();
        return this.concreteSlice.getClazzes();
    }

    public String toString() {
        if (this.concreteSlice != null) {
            return this.concreteSlice.toString();
        }
        return this.derivedSlice.toString();
    }
}

