/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.PartitionSlice;
import de.spricom.dessert.slicing.PartitionSliceFactory;
import de.spricom.dessert.slicing.SlicePartitioner;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PackageSlice
extends PartitionSlice {
    private final Map<String, PackageSlice> otherPackages;

    private PackageSlice(String packageName, Set<Clazz> entries, Map<String, PackageSlice> otherPackages) {
        super(packageName, entries);
        this.otherPackages = otherPackages;
    }

    public static SlicePartitioner partitioner() {
        return new SlicePartitioner(){

            @Override
            public String partKey(Clazz clazz) {
                return clazz.getPackageName();
            }
        };
    }

    public static PartitionSliceFactory<PackageSlice> factory() {
        return new PartitionSliceFactory<PackageSlice>(){

            @Override
            public PackageSlice createPartSlice(String packageName, Set<Clazz> entries, Map<String, PackageSlice> slices) {
                return new PackageSlice(packageName, entries, slices);
            }
        };
    }

    public String getPackageName() {
        return this.getPartKey();
    }

    public String getParentPackageName() {
        String packageName = this.getPackageName();
        int pos = packageName.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return packageName.substring(0, pos);
    }

    public PackageSlice getParentPackage() {
        PackageSlice parentPackage = this.otherPackages.get(this.getParentPackageName());
        if (parentPackage == null) {
            parentPackage = new PackageSlice(this.getParentPackageName(), Collections.<Clazz>emptySet(), this.otherPackages);
        }
        return parentPackage;
    }
}

