/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static URI getURI(Class<?> clazz) {
        URL url = clazz.getResource(ClassUtils.getShortName(clazz) + ".class");
        assert (url != null) : "Cannot find resource for " + clazz;
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Cannot convert '" + url + "' to URI", ex);
        }
    }

    public static String getShortName(Class<?> clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    public static File getRootFile(Class<?> clazz) {
        String filename = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(filename);
        assert (url != null) : "Resource " + filename + " not found!";
        if ("file".equals(url.getProtocol())) {
            assert (url.getFile().endsWith(filename)) : url + " does not end with " + filename;
            return new File(url.getFile().substring(0, url.getFile().length() - filename.length()));
        }
        if ("jar".equals(url.getProtocol())) {
            assert (url.getFile().startsWith("file:")) : url + " does not start with jar:file";
            assert (url.getFile().endsWith(".jar!" + filename)) : url + " does not end with .jar!" + filename;
            try {
                return new File(URLDecoder.decode(url.getFile().substring("file:".length(), url.getFile().length() - filename.length() - 1), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("UTF-8 encoding not supported!", ex);
            }
        }
        throw new IllegalArgumentException("Unknown protocol in " + url);
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isInnerType(Class<?> clazz) {
        return clazz.getEnclosingClass() != null;
    }
}

